/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.projectset.gradle.plugin;

import com.openexchange.projectset.data.ProjectSetFileReader;
import com.openexchange.projectset.gradle.plugin.ProjectSetPlugin;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.StartParameter;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.initialization.ProjectDescriptor;
import org.gradle.api.initialization.Settings;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\u001e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\bH\u0002J\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\r*\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u000eH\u0002J\u0012\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00120\r*\u00020\u0002H\u0002J\u0012\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\r*\u00020\u0002H\u0002J\u0012\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00120\r*\u00020\u0002H\u0002R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/openexchange/projectset/gradle/plugin/ProjectSetPlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/initialization/Settings;", "()V", "logger", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "psfFilter", "Ljava/io/FileFilter;", "apply", "", "settings", "listFilesRecursively", "", "Ljava/io/File;", "directory", "filter", "crawl", "", "file", "defaultPackages", "loadPackages", "readGradleProperties", "DirectoryFilter", "projectset"})
public final class ProjectSetPlugin
implements Plugin<Settings> {
    private final Logger logger = Logging.getLogger(ProjectSetPlugin.class);
    private final FileFilter psfFilter = psfFilter.1.INSTANCE;

    public void apply(@NotNull Settings settings) {
        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
        this.logger.trace("ProjectSet plugin");
        List<String> packages = this.loadPackages(settings);
        if (packages.isEmpty()) {
            throw (Throwable)new GradleException("You have to specify at least one package");
        }
        Iterable $receiver$iv = packages;
        for (Object element$iv : $receiver$iv) {
            String it = (String)element$iv;
            this.logger.trace("Including project " + it);
            settings.include(new String[]{it});
            Iterable $receiver$iv2 = this.crawl(settings, new File(settings.getRootDir(), it));
            for (Object element$iv2 : $receiver$iv2) {
                String crawledProject = (String)element$iv2;
                this.logger.trace("Including project " + crawledProject);
                settings.include(new String[]{crawledProject});
            }
        }
    }

    private final List<String> loadPackages(@NotNull Settings $receiver) {
        StartParameter startParameter = $receiver.getStartParameter();
        Intrinsics.checkExpressionValueIsNotNull((Object)startParameter, (String)"this.startParameter");
        if (startParameter.getProjectProperties().keySet().contains("packages")) {
            StartParameter startParameter2 = $receiver.getStartParameter();
            Intrinsics.checkExpressionValueIsNotNull((Object)startParameter2, (String)"this.startParameter");
            Map map = startParameter2.getProjectProperties();
            Intrinsics.checkExpressionValueIsNotNull((Object)map, (String)"this.startParameter.projectProperties");
            Object object = MapsKt.getValue((Map)map, (Object)"packages");
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"this.startParameter.proj\u2026ties.getValue(\"packages\")");
            List packages = StringsKt.split$default((CharSequence)((CharSequence)object), (String[])new String[]{","}, (boolean)false, (int)0, (int)6, null);
            this.logger.trace("Found packages property in start parameters with value " + packages + '.');
            return packages;
        }
        List<String> packages = this.readGradleProperties($receiver);
        if (packages.isEmpty()) {
            packages = this.defaultPackages($receiver);
        }
        return packages;
    }

    private final List<String> readGradleProperties(@NotNull Settings $receiver) {
        File file = new File($receiver.getRootDir(), "gradle.properties");
        if (!file.exists()) {
            return CollectionsKt.emptyList();
        }
        Properties properties = new Properties();
        try {
            File file2 = file;
            Properties properties2 = properties;
            FileInputStream fileInputStream = new FileInputStream(file2);
            properties2.load(fileInputStream);
        }
        catch (IOException e) {
            return CollectionsKt.emptyList();
        }
        Object object = properties.getProperty("packages");
        if (object == null || (object = StringsKt.split$default((CharSequence)((CharSequence)object), (String[])new String[]{","}, (boolean)false, (int)0, (int)6, null)) == null) {
            object = CollectionsKt.emptyList();
        }
        Object packages = object;
        this.logger.trace("Found packages property in gradle.properties with value " + packages);
        return packages;
    }

    private final List<String> defaultPackages(@NotNull Settings $receiver) {
        ProjectDescriptor projectDescriptor = $receiver.getRootProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)projectDescriptor, (String)"this.rootProject");
        String rootName = projectDescriptor.getName();
        File file = new File($receiver.getRootDir(), rootName + "-packages");
        if (!file.exists()) {
            return CollectionsKt.emptyList();
        }
        File file2 = $receiver.getRootDir();
        Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"this.rootDir");
        return CollectionsKt.listOf((Object)FilesKt.toRelativeString((File)file, (File)file2));
    }

    private final List<File> listFilesRecursively(File directory, FileFilter filter) {
        ArrayList<File> returnValue = new ArrayList<File>();
        for (File file : directory.listFiles(filter)) {
            returnValue.add(file);
        }
        File[] fileArray = directory.listFiles(new DirectoryFilter());
        int n = fileArray.length;
        for (int i = 0; i < n; ++i) {
            File subDir;
            File file = subDir = fileArray[i];
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"subDir");
            returnValue.addAll((Collection)this.listFilesRecursively(file, filter));
        }
        return returnValue;
    }

    private final List<String> crawl(@NotNull Settings $receiver, File file) {
        this.logger.trace("Crawling " + file);
        ArrayList<String> returnValue = new ArrayList<String>();
        Iterable $receiver$iv = this.listFilesRecursively(file, this.psfFilter);
        for (Object element$iv : $receiver$iv) {
            File it = (File)element$iv;
            this.logger.trace("Reading PSF file " + it);
            Iterable $receiver$iv2 = new ProjectSetFileReader(it).getProjectList();
            for (Object element$iv2 : $receiver$iv2) {
                String it2 = (String)element$iv2;
                File crawledFile = new File($receiver.getRootDir(), it2);
                if (!crawledFile.isDirectory()) continue;
                returnValue.add(it2);
                returnValue.addAll((Collection)this.crawl($receiver, crawledFile));
            }
        }
        this.logger.trace("Crawled list of projects " + returnValue);
        return returnValue;
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/openexchange/projectset/gradle/plugin/ProjectSetPlugin$DirectoryFilter;", "Ljava/io/FileFilter;", "()V", "accept", "", "f", "Ljava/io/File;", "projectset"})
    private static final class DirectoryFilter
    implements FileFilter {
        @Override
        public boolean accept(@NotNull File f) {
            Intrinsics.checkParameterIsNotNull((Object)f, (String)"f");
            return f.isDirectory();
        }
    }
}

