/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.operation;

import com.hazelcast.cache.impl.CacheService;
import com.hazelcast.cache.impl.operation.PartitionWideCacheOperation;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.config.CacheSimpleConfig;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.ReadonlyOperation;
import java.io.IOException;
import javax.cache.CacheException;

public class CacheGetConfigOperation
extends PartitionWideCacheOperation
implements ReadonlyOperation {
    private String simpleName;

    public CacheGetConfigOperation() {
    }

    public CacheGetConfigOperation(String name, String simpleName) {
        super(name);
        this.simpleName = simpleName;
    }

    @Override
    public void run() throws Exception {
        CacheSimpleConfig simpleConfig;
        CacheService service = (CacheService)this.getService();
        CacheConfig cacheConfig = service.getCacheConfig(this.name);
        if (cacheConfig == null && (simpleConfig = service.findCacheConfig(this.simpleName)) != null) {
            try {
                cacheConfig = new CacheConfig(simpleConfig);
                cacheConfig.setName(this.simpleName);
                cacheConfig.setManagerPrefix(this.name.substring(0, this.name.lastIndexOf(this.simpleName)));
                CacheConfig existingCacheConfig = service.createCacheConfigIfAbsent(cacheConfig);
                if (existingCacheConfig != null) {
                    cacheConfig = existingCacheConfig;
                }
            }
            catch (Exception e) {
                throw new CacheException((Throwable)e);
            }
        }
        this.response = cacheConfig;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeUTF(this.simpleName);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.simpleName = in.readUTF();
    }

    @Override
    public int getId() {
        return 27;
    }
}

