/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.clientside;

import com.hazelcast.cardinality.CardinalityEstimator;
import com.hazelcast.client.HazelcastClientNotActiveException;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.config.Config;
import com.hazelcast.core.Client;
import com.hazelcast.core.ClientService;
import com.hazelcast.core.Cluster;
import com.hazelcast.core.DistributedObject;
import com.hazelcast.core.DistributedObjectListener;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IAtomicLong;
import com.hazelcast.core.IAtomicReference;
import com.hazelcast.core.ICacheManager;
import com.hazelcast.core.ICountDownLatch;
import com.hazelcast.core.IExecutorService;
import com.hazelcast.core.IList;
import com.hazelcast.core.ILock;
import com.hazelcast.core.IMap;
import com.hazelcast.core.IQueue;
import com.hazelcast.core.ISemaphore;
import com.hazelcast.core.ISet;
import com.hazelcast.core.ITopic;
import com.hazelcast.core.IdGenerator;
import com.hazelcast.core.LifecycleService;
import com.hazelcast.core.MultiMap;
import com.hazelcast.core.PartitionService;
import com.hazelcast.core.ReplicatedMap;
import com.hazelcast.crdt.pncounter.PNCounter;
import com.hazelcast.durableexecutor.DurableExecutorService;
import com.hazelcast.flakeidgen.FlakeIdGenerator;
import com.hazelcast.instance.TerminatedLifecycleService;
import com.hazelcast.logging.LoggingService;
import com.hazelcast.mapreduce.JobTracker;
import com.hazelcast.quorum.QuorumService;
import com.hazelcast.ringbuffer.Ringbuffer;
import com.hazelcast.scheduledexecutor.IScheduledExecutorService;
import com.hazelcast.spi.impl.SerializationServiceSupport;
import com.hazelcast.spi.serialization.SerializationService;
import com.hazelcast.transaction.HazelcastXAResource;
import com.hazelcast.transaction.TransactionContext;
import com.hazelcast.transaction.TransactionException;
import com.hazelcast.transaction.TransactionOptions;
import com.hazelcast.transaction.TransactionalTask;
import java.util.Collection;
import java.util.concurrent.ConcurrentMap;

public class HazelcastClientProxy
implements HazelcastInstance,
SerializationServiceSupport {
    public volatile HazelcastClientInstanceImpl client;

    public HazelcastClientProxy(HazelcastClientInstanceImpl client) {
        this.client = client;
    }

    @Override
    public Config getConfig() {
        return this.getClient().getConfig();
    }

    @Override
    public String getName() {
        return this.getClient().getName();
    }

    @Override
    public <E> Ringbuffer<E> getRingbuffer(String name) {
        return this.getClient().getRingbuffer(name);
    }

    @Override
    public <E> IQueue<E> getQueue(String name) {
        return this.getClient().getQueue(name);
    }

    @Override
    public <E> ITopic<E> getTopic(String name) {
        return this.getClient().getTopic(name);
    }

    @Override
    public <E> ITopic<E> getReliableTopic(String name) {
        return this.getClient().getReliableTopic(name);
    }

    @Override
    public <E> ISet<E> getSet(String name) {
        return this.getClient().getSet(name);
    }

    @Override
    public <E> IList<E> getList(String name) {
        return this.getClient().getList(name);
    }

    @Override
    public <K, V> IMap<K, V> getMap(String name) {
        return this.getClient().getMap(name);
    }

    @Override
    public <K, V> MultiMap<K, V> getMultiMap(String name) {
        return this.getClient().getMultiMap(name);
    }

    @Override
    public <K, V> ReplicatedMap<K, V> getReplicatedMap(String name) {
        return this.getClient().getReplicatedMap(name);
    }

    @Override
    public JobTracker getJobTracker(String name) {
        return this.getClient().getJobTracker(name);
    }

    @Override
    public ILock getLock(String key) {
        return this.getClient().getLock(key);
    }

    @Override
    public ICacheManager getCacheManager() {
        return this.getClient().getCacheManager();
    }

    @Override
    public Cluster getCluster() {
        return this.getClient().getCluster();
    }

    @Override
    public Client getLocalEndpoint() {
        return this.getClient().getLocalEndpoint();
    }

    @Override
    public IExecutorService getExecutorService(String name) {
        return this.getClient().getExecutorService(name);
    }

    @Override
    public DurableExecutorService getDurableExecutorService(String name) {
        return this.getClient().getDurableExecutorService(name);
    }

    @Override
    public <T> T executeTransaction(TransactionalTask<T> task) throws TransactionException {
        return this.getClient().executeTransaction(task);
    }

    @Override
    public <T> T executeTransaction(TransactionOptions options, TransactionalTask<T> task) throws TransactionException {
        return this.getClient().executeTransaction(options, task);
    }

    @Override
    public TransactionContext newTransactionContext() {
        return this.getClient().newTransactionContext();
    }

    @Override
    public TransactionContext newTransactionContext(TransactionOptions options) {
        return this.getClient().newTransactionContext(options);
    }

    @Override
    public IdGenerator getIdGenerator(String name) {
        return this.getClient().getIdGenerator(name);
    }

    @Override
    public FlakeIdGenerator getFlakeIdGenerator(String name) {
        return this.getClient().getFlakeIdGenerator(name);
    }

    @Override
    public IAtomicLong getAtomicLong(String name) {
        return this.getClient().getAtomicLong(name);
    }

    @Override
    public <E> IAtomicReference<E> getAtomicReference(String name) {
        return this.getClient().getAtomicReference(name);
    }

    @Override
    public ICountDownLatch getCountDownLatch(String name) {
        return this.getClient().getCountDownLatch(name);
    }

    @Override
    public ISemaphore getSemaphore(String name) {
        return this.getClient().getSemaphore(name);
    }

    @Override
    public CardinalityEstimator getCardinalityEstimator(String name) {
        return this.getClient().getCardinalityEstimator(name);
    }

    @Override
    public PNCounter getPNCounter(String name) {
        return this.getClient().getPNCounter(name);
    }

    @Override
    public IScheduledExecutorService getScheduledExecutorService(String name) {
        return this.getClient().getScheduledExecutorService(name);
    }

    @Override
    public Collection<DistributedObject> getDistributedObjects() {
        return this.getClient().getDistributedObjects();
    }

    @Override
    public String addDistributedObjectListener(DistributedObjectListener distributedObjectListener) {
        return this.getClient().addDistributedObjectListener(distributedObjectListener);
    }

    @Override
    public boolean removeDistributedObjectListener(String registrationId) {
        return this.getClient().removeDistributedObjectListener(registrationId);
    }

    @Override
    public PartitionService getPartitionService() {
        return this.getClient().getPartitionService();
    }

    @Override
    public QuorumService getQuorumService() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ClientService getClientService() {
        return this.getClient().getClientService();
    }

    @Override
    public LoggingService getLoggingService() {
        return this.getClient().getLoggingService();
    }

    @Override
    public LifecycleService getLifecycleService() {
        HazelcastClientInstanceImpl hz = this.client;
        return hz != null ? hz.getLifecycleService() : new TerminatedLifecycleService();
    }

    @Override
    public <T extends DistributedObject> T getDistributedObject(String serviceName, String name) {
        return this.getClient().getDistributedObject(serviceName, name);
    }

    @Override
    public ConcurrentMap<String, Object> getUserContext() {
        return this.getClient().getUserContext();
    }

    public ClientConfig getClientConfig() {
        return this.getClient().getClientConfig();
    }

    @Override
    public HazelcastXAResource getXAResource() {
        return this.getClient().getXAResource();
    }

    @Override
    public void shutdown() {
        this.getLifecycleService().shutdown();
    }

    @Override
    public SerializationService getSerializationService() {
        return this.getClient().getSerializationService();
    }

    protected HazelcastClientInstanceImpl getClient() {
        HazelcastClientInstanceImpl c = this.client;
        if (c == null || !c.getLifecycleService().isRunning()) {
            throw new HazelcastClientNotActiveException("Client is not active.");
        }
        return c;
    }

    public String toString() {
        HazelcastClientInstanceImpl hazelcastInstance = this.client;
        if (hazelcastInstance != null) {
            return hazelcastInstance.toString();
        }
        return "HazelcastClientInstance {NOT ACTIVE}";
    }
}

