/**
 * OPEN-XCHANGE legal information
 *
 * All intellectual property rights in the Software are protected by
 * international copyright laws.
 *
 *
 * In some countries OX, OX Open-Xchange, open xchange and OXtender
 * as well as the corresponding Logos OX Open-Xchange and OX are registered
 * trademarks of the OX Software GmbH group of companies.
 * The use of the Logos is not covered by the GNU General Public License.
 * Instead, you are allowed to use these Logos according to the terms and
 * conditions of the Creative Commons License, Version 2.5, Attribution,
 * Non-commercial, ShareAlike, and the interpretation of the term
 * Non-commercial applicable to the aforementioned license is published
 * on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 * Please make sure that third-party modules and libraries are used
 * according to their respective licenses.
 *
 * Any modifications to this package must retain all copyright notices
 * of the original copyright holder(s) for the original code used.
 *
 * After any such modifications, the original and derivative code shall remain
 * under the copyright of the copyright holder(s) and/or original author(s)per
 * the Attribution and Assignment Agreement that can be located at
 * http://www.open-xchange.com/EN/developer/. The contributing author shall be
 * given Attribution for the derivative code and a license granting use.
 *
 *  Copyright (C) 2016-2020 OX Software GmbH
 *  Mail: info@open-xchange.com
 *
 *
 *  This program is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License, Version 2 as published
 *  by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *  or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *  for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc., 59
 *  Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */
package com.openexchange.office.tools.logging.v2.impl;

import org.slf4j.spi.LocationAwareLogger;

import com.openexchange.office.tools.logging.v2.ELogLevel;

//=============================================================================
public class Slf4JLogger extends LoggerBase
{
    //-------------------------------------------------------------------------
    private Slf4JLogger ()
    {}
    
    //-------------------------------------------------------------------------
    public static Slf4JLogger create (final Class< ? > aOwner)
    {
    	final Slf4JLogger aLog         = new Slf4JLogger ();
    	                  aLog.m_aLog  = (org.slf4j.spi.LocationAwareLogger) org.slf4j.LoggerFactory.getLogger(aOwner);
    	                  aLog.m_sFQCN = LogContext.class.getName();
    	return aLog;
    }
    
    //-------------------------------------------------------------------------
    @Override
    public synchronized boolean isActive (final ELogLevel eLevel)
    {
    	if (eLevel == ELogLevel.E_TRACE)
    		return m_aLog.isTraceEnabled();
    	if (eLevel == ELogLevel.E_DEBUG)
    		return m_aLog.isDebugEnabled();
    	if (eLevel == ELogLevel.E_INFO)
    		return m_aLog.isInfoEnabled();
    	if (eLevel == ELogLevel.E_WARNING)
    		return m_aLog.isWarnEnabled();
    	if (eLevel == ELogLevel.E_ERROR)
    		return m_aLog.isErrorEnabled();
    	if (eLevel == ELogLevel.E_FATAL)
    		return m_aLog.isErrorEnabled();
    	return false;
    }
    
    //-------------------------------------------------------------------------
    @Override
    protected synchronized void log (final ELogLevel eLevel    ,
    								 final String    sLog      ,
    								 final Throwable aException)
    {
    	if (aException == null)
    		impl_log (eLevel, sLog);
    	else
    		impl_log (eLevel, sLog, aException);
    }
    
    //-------------------------------------------------------------------------
    private void impl_log (final ELogLevel eLevel,
    					   final String    sLog  )
    {
    	final int nLevel = impl_mapLogLevel (eLevel);
    	m_aLog.log(null, m_sFQCN, nLevel, sLog, null, null);
    }
    
    //-------------------------------------------------------------------------
    private void impl_log (final ELogLevel eLevel    ,
    					   final String    sLog      ,
    					   final Throwable aException)
    {
    	final int nLevel = impl_mapLogLevel (eLevel);
    	m_aLog.log(null, m_sFQCN, nLevel, sLog, null, aException);
    }
    
    //-------------------------------------------------------------------------
    private static int impl_mapLogLevel (final ELogLevel eLevel)
    {
    	if (eLevel == ELogLevel.E_FATAL)
    		return LocationAwareLogger.ERROR_INT;
    	else
    	if (eLevel == ELogLevel.E_ERROR)
    		return LocationAwareLogger.ERROR_INT;
    	else
    	if (eLevel == ELogLevel.E_WARNING)
    		return LocationAwareLogger.WARN_INT;
    	else
    	if (eLevel == ELogLevel.E_INFO)
    		return LocationAwareLogger.INFO_INT;
    	else
    	if (eLevel == ELogLevel.E_DEBUG)
    		return LocationAwareLogger.DEBUG_INT;
    	else
    	if (eLevel == ELogLevel.E_TRACE)
    		return LocationAwareLogger.TRACE_INT;
    	else
    		throw new UnsupportedOperationException ("No support for log level '"+eLevel+"'.");
    }
    
    //-------------------------------------------------------------------------
    private org.slf4j.spi.LocationAwareLogger m_aLog = null;

    //-------------------------------------------------------------------------
    private String m_sFQCN = null;
}
