package com.openexchange.office.tools.logging.annotation;

import java.util.Map;

import org.slf4j.Logger;

public class LogMethodCallHelper {
		
	public static void logMethodCall(Logger logger, Object instance, String methodName, Object...params) {
		logMethodCall(logger, instance.getClass(), methodName, LogLevel.DEBUG, params);
	}

	public static void logMethodCall(Logger logger, Class<?> clazz, String methodName, LogLevel logLevel, Object...params) {
		StringBuilder strBuilderParams = buildParamLogString(params);
		log(logger, clazz, logLevel, methodName, strBuilderParams.toString(), "");
	}
	
	public static <T> T logMethodCallRes(Logger logger, Class<?> clazz, String methodName, T res, Object...params) {
		return logMethodCallRes(logger, clazz, methodName, LogLevel.DEBUG, res, params);
	}

	public static <T> T logMethodCallRes(Logger logger, Class<?> clazz, String methodName, LogLevel logLevel, T res, Object...params) {
		StringBuilder strBuilderParams = buildParamLogString(params);
		log(logger, clazz, logLevel, methodName, strBuilderParams.toString(), "");
		return res;
	}

	public static void logMethodCall(Loggable loggable, String methodName, Object...params) {
		logMethodCall(loggable, methodName, LogLevel.DEBUG, params);
	}

	public static void logMethodCall(Loggable loggable, String methodName, LogLevel logLevel, Object...params) {
		StringBuilder strBuilderParams = buildParamLogString(params);
		Class<?> clazz = loggable.getClass();
		log(loggable.getLogger(), clazz, logLevel, methodName, strBuilderParams.toString(), formatAdditionalInfoMap(loggable));
	}
	
	public static <T> T logMethodCallRes(Loggable loggable, String methodName, T res, Object...params) {
		return logMethodCallRes(loggable, methodName, LogLevel.DEBUG, res, params);
	}

	public static <T> T logMethodCallRes(Loggable loggable, String methodName, LogLevel logLevel, T res, Object...params) {
		StringBuilder strBuilderParams = buildParamLogString(params);
		log(loggable.getLogger(), loggable.getClass(), logLevel, methodName, strBuilderParams.toString(), formatAdditionalInfoMap(loggable));
		return res;
	}

	private static String formatAdditionalInfoMap(Loggable loggable) {
		Map<String, Object> addInfoMap = loggable.getAdditionalLogInfo();
		StringBuilder strBuilderAddInfo = new StringBuilder();
		boolean first = true;
		boolean found = false;
		for (Map.Entry<String, Object> entry : addInfoMap.entrySet()) {
			if (entry.getValue() != null) {
				if (!found) {
					strBuilderAddInfo.append(", additional info: ");
				}
				found = true;
				if (!first) {
					strBuilderAddInfo.append(", ");
				} else {
					first = false;
				}
				strBuilderAddInfo.append(entry.getKey());
				strBuilderAddInfo.append(": ");
				strBuilderAddInfo.append(entry.getValue());
			}
		}
		return strBuilderAddInfo.toString();
		
	}

	private static void log(Logger logger, Class<?> clazz, LogLevel logLevel, String methodName, String methodParams, String addInfo) {
		switch (logLevel) {
			case DEBUG: logger.debug("Called {}::{} with parameters {}{}", clazz.getName(), methodName, methodParams, addInfo);
								  break;
			case ERROR: logger.error("Called {}::{} with parameters {}{}", clazz.getName(), methodName, methodParams, addInfo);
			  					  break;			
			case INFO:  logger.info("Called {}::{} with parameters {}{}", clazz.getName(), methodName, methodParams, addInfo);
								  break;
			case TRACE: logger.trace("Called {}::{} with parameters {}{}", clazz.getName(), methodName, methodParams, addInfo);
								  break;
			case WARN:  logger.warn("Called {}::{} with parameters {}{}", clazz.getName(), methodName, methodParams, addInfo);
		}
	}

	private static StringBuilder buildParamLogString(Object... params) {
		StringBuilder strBuilderParams = new StringBuilder();
		boolean first = true;
		for (Object param : params) {
			if (!first) {
				strBuilderParams.append(", ");
			} else {
				first = false;
			}
			strBuilderParams.append((param != null) ? param.getClass().getName() : "null");
			strBuilderParams.append(", ");
			strBuilderParams.append(param);
		}
		return strBuilderParams;
	}	
	
	private LogMethodCallHelper() {}
}
