package com.openexchange.office.tools.logging;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;

public class LogHelper {

    private final Logger log;
    private final String id;

    public LogHelper(Logger log, String id) {
        this.log = log;
        this.id = id;
    }

    public void logDebug(String msg, Object ... vars) {
        if (log.isDebugEnabled()) {
            log.debug(getMsgWithVars(msg, toPairList(vars)));
        }
    }

    public void logInfo(String msg, Object ... vars) {
        if (log.isInfoEnabled()) {
            log.info(getMsgWithVars(msg, toPairList(vars)));
        }
    }

    public void logWarn(String msg, Object ... vars) {
        if (log.isWarnEnabled()) {
            log.warn(getMsgWithVars(msg, toPairList(vars)));
        }
    }

    public void logError(String msg, Throwable t, Object ... vars) {
        if (log.isErrorEnabled()) {
            log.error(getMsgWithVars(msg, toPairList(vars)), t);
        }
    }

    public void logError(String msg, Object ... vars) {
        if (log.isErrorEnabled()) {
            log.error(getMsgWithVars(msg, toPairList(vars)));
        }
    }

    private String getMsgWithVars(String msg, List<Pair<Object, Object>> vars) {
        StringBuilder strBuilder = new StringBuilder(msg);
        boolean first = true;
        for (Pair<Object, Object> p : vars) {
            if (!first) {
                strBuilder.append(", ");
            }
            first = false;
            strBuilder.append(p.getKey());
            strBuilder.append(" : ");
            strBuilder.append(p.getValue());
        }
        return strBuilder.toString();
    }

    private List<Pair<Object, Object>> toPairList(Object [] vars) {
        Validate.isTrue(vars.length % 2 == 0);
        List<Pair<Object, Object>> res = new ArrayList<>();
        if (this.id != null) {
            res.add(ImmutablePair.of("id", id));
        }
        for (int i=0;i<vars.length;i+=2) {
            res.add(ImmutablePair.of(vars[i], vars[i+1]));
        }
        return res;
    }
}
