/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.office.tools.logging;

import java.net.URL;

import org.slf4j.LoggerFactory;

import com.openexchange.exception.ExceptionUtils;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.util.StatusPrinter;

//==============================================================================
public class LogFactory
{
	//-------------------------------------------------------------------------
	public static final ELogFramework DEFAULT_LOG_FRAMEWORK = ELogFramework.E_OX;

	//-------------------------------------------------------------------------
	private LogFactory ()
	{}

	//-------------------------------------------------------------------------
	public static synchronized void establishLogBackStdOutMode ()
	{
		System.setProperty ("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.Log4JLogger");

		LoggerContext aLogBackContext = null;
	    try
	    {
			                  aLogBackContext = (LoggerContext) LoggerFactory.getILoggerFactory();
			JoranConfigurator aConfigurator   = new JoranConfigurator();

			aConfigurator.setContext(aLogBackContext);
			aLogBackContext.reset();
			
			URL aXMLConfigRes = LogFactory.class.getResource("/com/openexchange/office/tools/logging/res/logback-console.xml");
			aConfigurator.doConfigure(aXMLConfigRes);
	    }
	    catch (final Exception ex)
	    {
	    	// StatusPrinter will handle this ...
	    	// see below.
	    }

	    if (aLogBackContext != null)
	    	StatusPrinter.printInCaseOfErrorsOrWarnings(aLogBackContext);
	}

	//-------------------------------------------------------------------------
	public static synchronized void setLogFramework (final ELogFramework eNewLogType)
	{
		try
		{
			final LogFactory aFactory = impl_getSingleton ();
			if (aFactory.m_eFramework == eNewLogType)
				return;
		}
		catch (Throwable ex)
		{
        	ExceptionUtils.handleThrowable(ex);
		}
	}

	//-------------------------------------------------------------------------
	public static synchronized org.apache.commons.logging.Log getJclLog (final Class< ? > aClass)
	{
		final LogFactory                     aFactory = impl_getSingleton ();
		final org.apache.commons.logging.Log aLog     = aFactory.impl_getJclLog(aClass.getName ());
		return aLog;
	}

	//-------------------------------------------------------------------------
	public static synchronized org.apache.commons.logging.Log getJclLog (final String sClass)
	{
		final LogFactory                     aFactory = impl_getSingleton ();
		final org.apache.commons.logging.Log aLog     = aFactory.impl_getJclLog(sClass);
		return aLog;
	}

	//-------------------------------------------------------------------------
	public static synchronized org.slf4j.Logger getSlfLog (final Class< ? > aClass)
	{
		final LogFactory       aFactory = impl_getSingleton ();
		final org.slf4j.Logger aLog     = aFactory.impl_getSlfLog(aClass.getName ());
		return aLog;
	}

	//-------------------------------------------------------------------------
	public static synchronized org.slf4j.Logger getSlfLog (final String sClass)
	{
		final LogFactory       aFactory = impl_getSingleton ();
		final org.slf4j.Logger aLog     = aFactory.impl_getSlfLog(sClass);
		return aLog;
	}

	//-------------------------------------------------------------------------
	private static synchronized LogFactory impl_getSingleton ()
	{
		if (m_gSingleton == null)
			m_gSingleton = new LogFactory ();
		return m_gSingleton;
	}
	
	//-------------------------------------------------------------------------
	private org.apache.commons.logging.Log impl_getJclLog (final String sClass)
	{
		final org.apache.commons.logging.Log aLog = org.apache.commons.logging.impl.SLF4JLogFactory.getLog(sClass);
		return aLog;
	}

	//-------------------------------------------------------------------------
	private org.slf4j.Logger impl_getSlfLog (final String sClass)
	{
		final org.slf4j.Logger aLog = org.slf4j.LoggerFactory.getLogger(sClass);
		return aLog;
	}

	//-------------------------------------------------------------------------
	private static LogFactory m_gSingleton = null;
	
	//-------------------------------------------------------------------------
	private ELogFramework m_eFramework = DEFAULT_LOG_FRAMEWORK;
}
