/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.tools.doc;

/**
 * Provides the page size of a document, where the width and height
 * are defined in 1/100th mm.
 *
 * @author Carsten Driesner
 * @since 7.8.3
 */
public class PageSize {

    /**
     * Pre-defined page sizes based on paper sizes.
     */
    public final static PageSize A4 = new PageSize(21000, 29700);
    public final static PageSize LETTER = new PageSize(21590, 27940);

    private final int width;
    private final int height;

    /**
     * Initializes a new PageSize with width and height.
     *
     * @param width the width in 1/100th mm
     * @param height the height in 1/100th mm
     */
    public PageSize(int width, int height) {
        this.width = width;
        this.height = height;
    }

    /**
     * Provides the page width in 1/100th mm.
     *
     * @return the page width in 1/100th mm.
     */
    public int getWidth() {
        return width;
    }

    /**
     * Provides the page height in 1/100th mm.
     *
     * @return the page height in 1/100th mm.
     */
    public int getHeight() {
        return height;
    }
}
