package com.openexchange.office.tools.config;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import com.openexchange.config.ConfigurationService;
import com.openexchange.office.tools.common.reflection.TypeConverter;
import com.openexchange.office.tools.osgi.ServiceLookupRegistry;

//=============================================================================
public class ConfigBase
{
	//-------------------------------------------------------------------------
	protected synchronized < T > T getValue (final String     sKey    ,
								             final Class< T > aType   ,
								             final T          aDefault)
	{
		T aValue = impl_getValueOverwrite (sKey);
		if (aValue != null)
		    return aValue;

		aValue = impl_getValueDirect (sKey, aType);
		if (aValue != null)
			return aValue;

		aValue = aDefault;
		return aValue;
	}

	//-------------------------------------------------------------------------
    protected synchronized < T > void setOverwriteValue (final String sKey  ,
                                                         final T      aValue)
        throws Exception
    {
        final Map< String, Object > aOverwrite = mem_OverwriteItems ();
        aOverwrite.put (sKey, aValue);
    }

    //-------------------------------------------------------------------------
    private /* no synchronized */ < T > T impl_getValueDirect (final String     sKey ,
                                                               final Class< T > aType)
    {
        final ConfigurationService aConfig = mem_Config ();
              T                    aValue  = null;

        try
        {
            final String sValue = aConfig.getProperty(sKey);
                         aValue = (T) TypeConverter.fromString(sValue, aType);
        }
        catch (Throwable ex)
        {
            aValue = null;
        }

        return aValue;
    }

    //-------------------------------------------------------------------------
    @SuppressWarnings("unchecked")
    private /* no synchronized */ < T > T impl_getValueOverwrite (final String sKey)
    {
        final Map< String, Object > aOverwrite = mem_OverwriteItems ();
        final Object                aValue     = aOverwrite.get (sKey);
        return (T) aValue;
    }

    //-------------------------------------------------------------------------
	protected synchronized ConfigurationService mem_Config ()
	{
		ConfigurationService aConfig = null;

		if (m_rConfig != null)
			aConfig = m_rConfig.get ();

		if (aConfig == null)
		{
			final ServiceLookupRegistry aLookup = ServiceLookupRegistry.get ();
			                            aConfig = aLookup.getService(ConfigurationService.class);
			m_rConfig = new WeakReference< ConfigurationService > (aConfig);
		}

		Validate.notNull(aConfig, "No ConfigurationService available.");

		return aConfig;
	}

    //-------------------------------------------------------------------------
    private synchronized Map< String, Object > mem_OverwriteItems ()
    {
        if (m_lOverwriteItems == null)
            m_lOverwriteItems = new HashMap< String, Object > ();
        return m_lOverwriteItems;
    }

	//-------------------------------------------------------------------------
	private WeakReference< ConfigurationService > m_rConfig = null;

	//-------------------------------------------------------------------------
	private Map< String, Object > m_lOverwriteItems = null;
}
