package com.openexchange.office.rt2.protocol.value;

import org.apache.commons.lang3.Validate;

public abstract class RT2ValueType<T> {

    private final T value;

    public RT2ValueType(T value) {
        this(value, true);
    }

    public RT2ValueType(T value, boolean validateNotNull) {
        if (validateNotNull) {
            Validate.notNull(value);
        }
        this.value = value;
    }

    public T getValue() {
        return value;
    }

    @Override
    public String toString() {
        return value.toString();
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((value == null) ? 0 : value.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        @SuppressWarnings("rawtypes")
        RT2ValueType other = (RT2ValueType) obj;
        if (value == null) {
            if (other.value != null)
                return false;
        } else if (!value.equals(other.value))
            return false;
        return true;
    }
}
