package com.openexchange.office.rt2.protocol;

import java.util.HashMap;
import java.util.Map;

import javax.jms.JMSException;
import javax.jms.Message;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.openexchange.office.rt2.protocol.value.RT2MessageType;

public class RT2MessageJmsPostProcessor implements RT2MessagePostProcessor {

    private static final Logger log = LoggerFactory.getLogger(RT2MessageJmsPostProcessor.class);

    public static final String HEADER_MSG_TYPE  = RT2Protocol.HEADER_PREFIX_INTERNAL + ".type";

    private final RT2Message rt2Message;

    public RT2MessageJmsPostProcessor(RT2Message rt2Message) {
        this.rt2Message = rt2Message;
    }

    @Override
    public Message postProcessMessage(Message msg) throws JMSException {
    	msg.setBooleanProperty(HEADER_VERSION_MSG_RCV, false);
    	msg.setBooleanProperty(HEADER_VERSION_MSG_SND, false);
        msg.setStringProperty(HEADER_MSG_TYPE, rt2Message.getType().getValue());
        msg.setBooleanProperty( HEADER_GPB_MSG, false);
        Map<String, Object> debugMap = null;
        if (log.isDebugEnabled()) {
            debugMap = new HashMap<>();
        }
        for (String header : rt2Message.listHeader()) {
            if (!header.equals("internal.type")) {
                Object value = rt2Message.getHeader(header);
                if (value instanceof RT2MessageType) {
                    RT2MessageType rt2MsgType = (RT2MessageType) value;
                    value = rt2MsgType.getValue();
                }
                if (debugMap != null) {
                    debugMap.put(header, value);
                }
                msg.setObjectProperty(header, value);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Header: {}", debugMap);
        }
        return msg;
    }
}
