/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.rt2.hazelcast.management;

import java.util.HashMap;
import java.util.Map;
import java.util.Map.Entry;

import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

import com.hazelcast.core.IMap;
import com.openexchange.exception.OXException;
import com.openexchange.management.ManagementObject;
import com.openexchange.office.rt2.hazelcast.HzNodeHealthMap;
import com.openexchange.office.rt2.hazelcast.serialization.PortableNodeHealthState;

public class HzNodeHealthMapManagement extends ManagementObject<HzNodeHealthMapMBean> implements HzNodeHealthMapMBean
{
    private ObjectName objectName = null;
    private final HzNodeHealthMap nodeHealthMap;

    /**
     * Initializes a new {@link RealtimeConfigManagement}.
     * @param mbeanInterface
     * @param isMxBean
     * @throws IllegalArgumentException if the String is missing
     */
    public HzNodeHealthMapManagement(HzNodeHealthMap nodeHealthMap) {
        super(HzNodeHealthMapMBean.class);
        this.nodeHealthMap = nodeHealthMap;
    }

    @Override
    public ObjectName getObjectName()
    {
        if (objectName == null)
        {
            final String directoryName = "NodeHealthMap";
            try
            {
                objectName = new ObjectName("com.openexchange.office.rt2", "name", directoryName);
            } 
            catch (MalformedObjectNameException e)
            {
                // can't happen: valid domain and no missing parameters
            }
            catch (NullPointerException e)
            {
                // can't happen: valid domain and no missing parameters
            }
        }
        return objectName;
    }

    @Override
    public Map<String, String> getHealthMapping() throws OXException
    {
       final IMap<String, PortableNodeHealthState> healthStateMapping = nodeHealthMap.getHealthStateMapping();
       final Map<String, String> jmxMap = new HashMap<>(healthStateMapping.size());
       for (Entry<String, PortableNodeHealthState> entry : healthStateMapping.entrySet()) {
           final String sUUID = entry.getKey();
           final PortableNodeHealthState aHealthState = entry.getValue();
           jmxMap.put(sUUID, aHealthState.toString());
       }

       return jmxMap;
	}

}
