/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.rt2.ws;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

import org.apache.commons.lang3.StringUtils;

public class UpgradeRequestWrapper extends HttpServletRequestWrapper {
	private static final String USER_AGENT_MS_EDGE = "Mozilla/5.0 (Windows NT 10.0; Win64; x64; ServiceUI 14) Edge/18";

	private final boolean fakeMSEdge;

	public UpgradeRequestWrapper(HttpServletRequest request) {
		super(request);
		fakeMSEdge = false;
	}

	public UpgradeRequestWrapper(HttpServletRequest request, boolean fakeMSEdge) {
		super(request);
		this.fakeMSEdge = fakeMSEdge;
	}

	@Override
    public String getHeader(String name) {
    	if ("user-agent".equalsIgnoreCase(name)) {
    		String userAgent = super.getHeader(name);
    		if (StringUtils.isEmpty(userAgent) && fakeMSEdge) {
    			// ATTENTION: This is a workaround and can fail if the backend
    			// code changes the browser detection.
    			// We know that MS Edge has an issue that it doesn't send any
    			// user-agent info via a websocket connection. In this special
    			// case we fake the user-agent to ensure that a valid is set.
    			return USER_AGENT_MS_EDGE;
    		}
    		return userAgent;
    	} else {
    		return super.getHeader(name);
    	}
    }

}
