package com.openexchange.office.rt2.proxy;

import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricRegistry;

public class MessageCounters {

    private final Counter joinRequestCounter;
    private final Counter joinResponseCounter;
    private final Counter openRequestCounter;
    private final Counter openResponseCounter;
    private final Counter closeRequestCounter;
    private final Counter closeResponseCounter;
    private final Counter leaveRequestCounter;
    private final Counter leaveResponseCounter;
    private final Counter abortCounter;
    
    public MessageCounters(MetricRegistry metricRegistry) {
    	this.joinRequestCounter = metricRegistry.counter(MetricRegistry.name("MessageCounter", "request", "join"));
    	this.joinResponseCounter = metricRegistry.counter(MetricRegistry.name("MessageCounter", "response", "join"));
    	this.openRequestCounter = metricRegistry.counter(MetricRegistry.name("MessageCounter", "request", "open"));
    	this.openResponseCounter = metricRegistry.counter(MetricRegistry.name("MessageCounter", "response", "open"));
    	this.closeRequestCounter = metricRegistry.counter(MetricRegistry.name("MessageCounter", "request", "close"));
    	this.closeResponseCounter = metricRegistry.counter(MetricRegistry.name("MessageCounter", "response", "close"));
    	this.leaveRequestCounter = metricRegistry.counter(MetricRegistry.name("MessageCounter", "request", "leave"));
    	this.leaveResponseCounter = metricRegistry.counter(MetricRegistry.name("MessageCounter", "response", "leave"));
    	this.abortCounter = metricRegistry.counter(MetricRegistry.name("MessageCounter", "abort"));
    }
    
    public void incJoinRequestCounter() {
    	this.joinRequestCounter.inc();
    }
    
    public void incJoinResponseCounter() {
    	this.joinResponseCounter.inc();
    }
    
    public void incOpenRequestCounter() {
    	this.openRequestCounter.inc();
    }
    
    public void incOpenResponseCounter() {
    	this.openResponseCounter.inc();
    }
    
    public void incCloseRequestCounter() {
    	this.closeRequestCounter.inc();
    }
    
    public void incCloseResponseCounter() {
    	this.closeResponseCounter.inc();
    }
    
    public void incLeaveRequestCounter() {
    	this.leaveRequestCounter.inc();
    }
    
    public void incLeaveResponseCounter() {
    	this.leaveResponseCounter.inc();
    }
    
    public void incAbortCounter() {
    	this.abortCounter.inc();
    }
}
