package com.openexchange.office.rt2.jms;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.ActiveMQSslConnectionFactory;
import org.apache.activemq.management.JMSStatsImpl;
import org.apache.activemq.transport.Transport;

public class EnhActiveMQSSLConnectionFactory extends ActiveMQSslConnectionFactory {

	private Set<ActiveMQConnection> connections = new HashSet<>();
	
	@Override
	protected ActiveMQConnection createActiveMQConnection(Transport transport, JMSStatsImpl stats) throws Exception {
		ActiveMQConnection res = super.createActiveMQConnection(transport, stats);
		synchronized (connections) {
			connections.add(res);
		}		
		return res;
	}
	
	public Set<ActiveMQConnection> getConnections() {
		Set<ActiveMQConnection> res = new HashSet<>();
		synchronized (connections) {
			Iterator<ActiveMQConnection> ite = connections.iterator();
			while (ite.hasNext()) {
				ActiveMQConnection conn = ite.next();
				if (conn.isStarted()) {
					res.add(conn);
				} else {
					ite.remove();
				}
			}
		}		 
		return res;
	}
}
