package com.openexchange.office.rt2.cache;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import com.hazelcast.core.DistributedObject;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IAtomicLong;
import com.openexchange.office.rt2.core.RT2GarbageCollector;

public class RT2HazelcastHelperService {

	private final HazelcastInstance hzInstance;
	
	public RT2HazelcastHelperService(HazelcastInstance hzInstance) {
		this.hzInstance = hzInstance;
	}

	public Map<String, IAtomicLong> getAllClientRefCountObjects() {
		
		final Collection<DistributedObject> aDistributedObjects = hzInstance.getDistributedObjects();
        final Set<DistributedObject>        aClientRefCountSet  = aDistributedObjects.stream()
                .filter(RT2GarbageCollector::isAtomicLong)
                .filter(RT2GarbageCollector::isClientRefCountObject)
                .collect(Collectors.toSet());
        Map<String, IAtomicLong> res = new HashMap<>();
        aClientRefCountSet.forEach(distObj -> res.put(distObj.getName(), (IAtomicLong) distObj));
        return res;
	}
	
	public int getCountMembers() {
		return hzInstance.getCluster().getMembers().size();
	}
}
