/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.ot.tools;

import java.util.Map;
import com.google.common.collect.ImmutableMap;
import com.openexchange.office.filter.api.OCValue;

public enum OpAlias {

    ALIAS_IGNORABLE("alias_Ignorable"),
    ALIAS_INSERT_CHAR("alias_InsertChar"),
    ALIAS_INSERT_COMP("alias_InsertComp"),
    ALIAS_MERGE_COMP("alias_MergeComp"),
    ALIAS_SPLIT_COMP("alias_SplitComp");

    final static Map<OCValue, OpAlias> aliasMap = new ImmutableMap.Builder<OCValue, OpAlias>()
        // ALIAS_IGNORABLE
        .put(OCValue.INSERT_THEME, ALIAS_IGNORABLE)
        .put(OCValue.INSERT_FONT_DESCRIPTION, ALIAS_IGNORABLE)
        .put(OCValue.NO_OP, ALIAS_IGNORABLE)
        // ALIAS_INSERT_CHAR
        .put(OCValue.INSERT_TAB, ALIAS_INSERT_CHAR)
        .put(OCValue.INSERT_TEXT, ALIAS_INSERT_CHAR)
        .put(OCValue.INSERT_FIELD, ALIAS_INSERT_CHAR)
        .put(OCValue.INSERT_BOOKMARK, ALIAS_INSERT_CHAR)
        .put(OCValue.INSERT_HARD_BREAK, ALIAS_INSERT_CHAR)
        .put(OCValue.INSERT_RANGE, ALIAS_INSERT_CHAR)
        // ALIAS_INSERT_COMP
        .put(OCValue.INSERT_PARAGRAPH, ALIAS_INSERT_COMP)
        .put(OCValue.INSERT_TABLE, ALIAS_INSERT_COMP)
        // ALIAS_MERGE_COMP
        .put(OCValue.MERGE_PARAGRAPH, ALIAS_MERGE_COMP)
        .put(OCValue.MERGE_TABLE, ALIAS_MERGE_COMP)
        // ALIAS_SPLIT_COMP
        //.put(OCValue.SPLIT_PARAGRAPH, ALIAS_SPLIT_COMP)
        //.put(OCValue.SPLIT_TABLE, ALIAS_SPLIT_COMP)
        .build();

    final private String alias;

    private OpAlias(String alias) {
        this.alias = alias;
    }

    public String value() {
        return alias;
    }

    public static OpAlias fromValue(OCValue val) {
        return aliasMap.get(val);
    }

    @Override
    public String toString() {
        return alias;
    }
}
