package com.openexchange.office.htmldoc;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import com.openexchange.office.filter.api.OCKey;

public class Drawing
        extends NodeHolder
{ //  isdrawingtablenode

    private static final String  CONTENT_START       = "<div contenteditable='false' ";
    private static final String  START               = " class='drawing inline' contenteditable='false' style='width: 50px; height: 50px; border: none;'>";
    private static final String  DRAWING_CONTENT     = "<div class='content'>";
    private static final String  PLACEHOLDER_CONTENT = "<div class='content placeholder'>";
    private static final String  GROUP_CONTENT       = "<div class='content groupcontent'>";
    private static final String  SHAPE_CONTENT       = "<div class='content textframecontent'><div class='textframe' contenteditable='true'>";
    private static final String  CONTENT_IMAGE_START = "<img src='";
    private static final String  CONTENT_IMAGE_START_PRESENTATION = "<img __imagesource__='"; // docs-963
    private static final String  CONTENT_IMAGE_END   = "' style='left: 0px; top: 0px; width: 50px; height: 50px;'>";
    private static final String  DIV_END             = "</div>";

    // ///////////////////////////////////////////////////////////

    private static AtomicInteger idCounter           = new AtomicInteger();

    // ///////////////////////////////////////////////////////////

    private final String         id;
    private final String         type;
    private final String         fileVersion;
    private final String         folderId;
    private final String         fileId;

    private boolean              emptySpans          = true;
    private boolean              emptySpanStyle      = true;
    private boolean              havePlaceholder     = true;

    private String               src                 = null;
    private boolean              presentation        = false;
    private String target;

//    private JSONArray       tableGrid;
//    private int             allW;

    public Drawing(
            String type, String fileId, String folderId, String fileVersion)
                throws Exception
    {
        this.fileId = fileId;
        this.folderId = folderId;
        this.fileVersion = fileVersion;
        this.type = type;
        this.id = "frame" + idCounter.getAndIncrement();
//        this.tableGrid = null;
//        this.allW = 0;

        // TODO: Is it necessary to format the table already on server side?
//        if (type.equalsIgnoreCase("table")) {
//
//            // handling of table attributes
//            final JSONObject table = attrs.getJSONObject("table");
//
//            this.tableGrid = table.getJSONArray(OCKey.TABLE_GRID.shortName());
//
//            int allW = 0;
//            for (int i = 0; i < tableGrid.length(); i++)
//            {
//                allW += tableGrid.getInt(i);
//            }
//            this.allW = allW;
//        }

    }

    public Drawing setPresentation(
        boolean presentation)
    {
        this.presentation = presentation;
        if (presentation) {
            havePlaceholder = false;
        }
        return this;
    }

    @Override
    public boolean setAttribute(
        JSONArray start,
        JSONArray end,
        JSONObject assignedAttrs)
            throws Exception
    {

        super.setAttribute(start, end, assignedAttrs);

        if (start.length() == 0)
        {
            // type must be checked now, because we support more than image
            if ((null != type) && (type.equalsIgnoreCase("image")))
            {
                src = ""; // not using any source (48715)

                JSONObject attrs = getAttribute();
                if (attrs != null) {
                    // fix for Bug 51986
                    if (attrs.has(OCKey.IMAGE.value())) {
                        JSONObject drawing = attrs.getJSONObject(OCKey.IMAGE.value());
                        String imageUrl = drawing.optString(OCKey.IMAGE_URL.value(), "");
                        if (imageUrl.contains("://")) {
                            src = imageUrl;
                        } else if (!imageUrl.isEmpty()) {
                            src = "/appsuite/api/oxodocumentfilter?id=" + fileId + "&folder_id=" + folderId + "&action=getfile&get_filename=" + imageUrl + "&version=" + fileVersion + "&filename=drawing";
                        }
                    }
                }
            }
            return false;
        }
        else
        {
            return true;
        }

    }

    @Override
    public boolean appendContent(
        StringBuilder document)
            throws Exception
    {

        if (emptySpans)
        {
            GenDocHelper.addEmptySpan(document, emptySpanStyle);
        }

        document.append(CONTENT_START);

        final JSONObject adapter = new JSONObject();

        adapter.put(OCKey.TYPE.value(), this.type);
        adapter.put(OCKey.UID.value(), id);
        adapter.put("model", JSONObject.NULL);

        adapter.put("attributes", getAttribute());

        GenDocHelper.appendJQueryData(document, adapter);

        document.append("' data-type='");
        document.append(GenDocHelper.escapeUIString(type));
        document.append("' ");

        // System.out.println("Drawing.appendContent() " + this.type);

        String content = START;

        if (presentation)
        {
            content = "";
            if (null != target) {
                content += " target='" + GenDocHelper.escapeUIString(target) + "'";
            }

            content += "contenteditable='false' class='drawing absolute'>";
        }

        document.append(content);
        // System.out.println("Drawing.appendContent() " + content);
        if (type.equalsIgnoreCase("image"))
        {

            document.append(DRAWING_CONTENT);

            if (!src.isEmpty()) {
                String image;
                if (presentation) {
                    image = CONTENT_IMAGE_START_PRESENTATION;
                } else {
                    image = CONTENT_IMAGE_START;
                }
                image += GenDocHelper.escapeUIString(src);
                image += CONTENT_IMAGE_END;

                document.append(image);
            }

        }
        else if (type.equalsIgnoreCase("group"))
        {
            document.append(GROUP_CONTENT);
            super.appendContent(document);
        }
        else if (type.equalsIgnoreCase("shape") || type.equalsIgnoreCase("connector"))
        {
            document.append(SHAPE_CONTENT);
            super.appendContent(document);
            document.append(DIV_END);
        }
        else if (type.equalsIgnoreCase("table"))
        {
            document.append(SHAPE_CONTENT);

        	// Handling for the table node

            document.append("<table ");
//             GenDocHelper.appendAttributes(getAttribute(), document);
            document.append("role='grid' class='isdrawingtablenode' style='width: 100%; background-color: transparent;'><colgroup>");

            // TODO: Table formatting already on server side?
//            for (int i = 0; i < tableGrid.length(); i++)
//            {
//                final double w = Math.round((tableGrid.getDouble(i) / allW) * 1000.0) / 10.0;
//                document.append("<col style='width: " + w + "%;'>");
//            }
            document.append("</colgroup><tbody>");

            super.appendContent(document);

            document.append("</tbody></table>");

            document.append(DIV_END);
        }
        else
        {
            // default behavior for types we cant handle yet (chart)
            document.append(PLACEHOLDER_CONTENT);
            super.appendContent(document);
        }

        document.append(DIV_END);
        document.append(DIV_END);

        if (!presentation && emptySpans)
        {
            GenDocHelper.addEmptySpan(document, emptySpanStyle);
        }
        return false;
    }

    public String getPHType(){
        JSONObject attrs = getAttribute();
        if (null == attrs) {
            return null;
        }

        JSONObject pres = attrs.optJSONObject(OCKey.PRESENTATION.value());
        if (null == pres) {
            return null;
        }
        String phType = pres.optString(OCKey.PH_TYPE.value());
        if (StringUtils.isEmpty(phType)) {
            return null;
        }
        return phType;
    }

    @Override
    public boolean needsEmptySpan()
    {
        return false;
    }

    @Override
    public int getTextLength()
    {
        return 1;
    }

    @Override
    public void insert(
        JSONArray start,
        INode newChild)
            throws Exception
    {
        // System.out.println("Drawing.insert() " + start + " " + newChild.getClass());
        if (start.length() == 1)
        {
            if (newChild instanceof Drawing)
            {
                ((Drawing) newChild).disableEmptySpans();
            }
            else if ((newChild instanceof Paragraph) || (newChild instanceof Table))
            {
                havePlaceholder = false;
            }
        }
        super.insert(start, newChild);
    }

    public void disableEmptySpans()
    {
        this.emptySpans = false;
    }

    public void disableEmptySpanStyle()
    {
        this.emptySpanStyle = false;
    }

    public Drawing setTarget(
        String target)
    {
        this.target = target;
        return this;
    }
}
