/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.filter.ooxml.xlsx.components;

import org.docx4j.dml.spreadsheetdrawing.AnchorBase;
import org.docx4j.dml.spreadsheetdrawing.CTConnector;
import org.docx4j.dml.spreadsheetdrawing.CTGraphicalObjectFrame;
import org.docx4j.dml.spreadsheetdrawing.CTGroupShape;
import org.docx4j.dml.spreadsheetdrawing.CTPicture;
import org.docx4j.dml.spreadsheetdrawing.CTShape;
import org.docx4j.dml.spreadsheetdrawing.CTTwoCellAnchor;
import org.docx4j.mce.AlternateContent.Choice;
import org.json.JSONException;
import org.json.JSONObject;
import org.xlsx4j.sml.Sheet;
import com.openexchange.office.filter.core.DLNode;
import com.openexchange.office.filter.core.component.Component;
import com.openexchange.office.filter.core.component.ComponentContext;
import com.openexchange.office.filter.core.IContentAccessor;
import com.openexchange.office.filter.core.DLList;
import com.openexchange.office.filter.ooxml.OfficeOpenXMLOperationDocument;
import com.openexchange.office.filter.ooxml.components.OfficeOpenXMLComponent;
import com.openexchange.office.filter.ooxml.xlsx.XlsxOperationDocument;
import com.openexchange.office.filter.ooxml.xlsx.tools.Drawings;

public class SheetComponent extends XlsxComponent {

    final private Sheet sheet;

    public SheetComponent(ComponentContext<OfficeOpenXMLOperationDocument> parentContext, DLNode<Object> _node, int _componentNumber) {
        super(parentContext, _node, _componentNumber);

        sheet = (Sheet)_node.getData();
        sheet.setContentAccessor(new SheetWrapper(sheet, (XlsxOperationDocument)operationDocument));
    }

    public SheetComponent(Sheet sheet, XlsxOperationDocument operationDocument, int _componentNumber) {
        super(operationDocument, new DLNode<Object>(sheet), _componentNumber);

        this.sheet = sheet;
        sheet.setContentAccessor(new SheetWrapper(sheet, operationDocument));
    }

    @Override
	public Component<OfficeOpenXMLOperationDocument> getNextChildComponent(ComponentContext<OfficeOpenXMLOperationDocument> previousChildContext, Component<OfficeOpenXMLOperationDocument> previousChildComponent) {
        final DLNode<Object> sheetNode = getNode();
        final DLList<Object> nodeList = (DLList<Object>)((IContentAccessor)sheetNode.getData()).getContent();
        final int nextComponentNumber = previousChildComponent!=null?previousChildComponent.getNextComponentNumber():0;
        DLNode<Object> childNode = previousChildContext!=null ? previousChildContext.getNode().getNext() : nodeList.getFirstNode();

        OfficeOpenXMLComponent nextComponent = null;
        for(; nextComponent==null&&childNode!=null; childNode = childNode.getNext()) {
            final Object o = getContentModel(childNode, sheetNode.getData());
            if(o instanceof AnchorBase) {
                final AnchorBase cellAnchor = (AnchorBase)o;

                OfficeOpenXMLComponent alt = null;
                if (cellAnchor.getAlternateContent() != null) {
                    Choice choise = cellAnchor.getAlternateContent().getChoice().get(0);
                    String requires = choise.getRequires();
                    if ("cx1".equals(requires) || "cx2".equals(requires) || "cx4".equals(requires)) {
                        for (Object ch : choise.getAny()) {
                            if (ch instanceof CTGraphicalObjectFrame) {
                                alt = new ShapeGraphicComponent(this, childNode, (CTGraphicalObjectFrame) ch, cellAnchor, nextComponentNumber);
                                break;
                            }
                        }
                    }

                }

                if (alt != null) {
                    nextComponent = alt;
                    continue;
                }

                if(cellAnchor.getGrpSp()!=null) {
                    nextComponent = new ShapeGroupComponent(this, childNode, cellAnchor.getGrpSp(), cellAnchor, nextComponentNumber);
                }
                else if(cellAnchor.getSp()!=null) {
                    nextComponent = new ShapeComponent(this, childNode, cellAnchor.getSp(), cellAnchor, nextComponentNumber);
                }
                else if(cellAnchor.getGraphicFrame()!=null) {
                    nextComponent = new ShapeGraphicComponent(this, childNode, cellAnchor.getGraphicFrame(), cellAnchor, nextComponentNumber);
                }
                else if(cellAnchor.getCxnSp()!=null) {
                    nextComponent = new ShapeConnectorComponent(this, childNode, cellAnchor.getCxnSp(), cellAnchor, nextComponentNumber);
                }
                else if(cellAnchor.getPic()!=null) {
                    nextComponent = new ShapePicComponent(this, childNode, cellAnchor.getPic(), cellAnchor, nextComponentNumber);
                }
            }
        }
        return nextComponent;
    }

    @Override
    public Component<OfficeOpenXMLOperationDocument> insertChildComponent(ComponentContext<OfficeOpenXMLOperationDocument> parentContext, DLNode<Object> contextNode, int number, Component<OfficeOpenXMLOperationDocument> child, Component.Type type, JSONObject attrs) {

        DLList<Object> DLList = ((Sheet)contextNode.getData()).getContent();
        DLNode<Object> referenceNode = child!=null ? child.getNode() : null;

        final CTTwoCellAnchor cellAnchor = new CTTwoCellAnchor();
        switch(type) {
        	case AC_SHAPE: {
	            final CTShape newChild = Drawings.createShape();
	            cellAnchor.setSp(newChild);
	            newChild.setParent(contextNode.getData());
	            final DLNode<Object> newChildNode = new DLNode<Object>(newChild);
	            DLList.addNode(referenceNode, newChildNode, true);
	            return new ShapeComponent(parentContext, newChildNode, newChild, cellAnchor, number);
        	}
        	case AC_GROUP: {
	            final CTGroupShape newChild = Drawings.createGroupShape();
	            cellAnchor.setGrpSp(newChild);
	            newChild.setParent(contextNode.getData());
	            final DLNode<Object> newChildNode = new DLNode<Object>(newChild);
	            DLList.addNode(referenceNode, newChildNode, true);
	            return new ShapeGroupComponent(parentContext, newChildNode, newChild, cellAnchor, number);
        	}
        	case AC_CHART: {
                try {
                    final CTGraphicalObjectFrame newChild = Drawings.createChart(getOperationDocument(), getOperationDocument().getContextPart(), new JSONObject());
                    cellAnchor.setGraphicFrame(newChild);
                    newChild.setParent(contextNode.getData());
                    final DLNode<Object> newChildNode = new DLNode<Object>(newChild);
                    DLList.addNode(referenceNode, newChildNode, true);
                    return new ShapeGraphicComponent(parentContext, newChildNode, newChild, cellAnchor, number);
                }
                catch(Exception e) {
                    throw new UnsupportedOperationException();
                }
        	}
            case AC_CONNECTOR: {
                final CTConnector newChild = Drawings.createConnectorShape();
                cellAnchor.setCxnSp(newChild);
                newChild.setParent(contextNode.getData());
                final DLNode<Object> newChildNode = new DLNode<Object>(newChild);
                DLList.addNode(referenceNode, newChildNode, true);
                return new ShapeConnectorComponent(parentContext, newChildNode, newChild, cellAnchor, number);
            }
            case AC_IMAGE: {
                final CTPicture newChild = Drawings.createImage();
                cellAnchor.setPic(newChild);
                newChild.setParent(contextNode.getData());
                final DLNode<Object> newChildNode = new DLNode<Object>(newChild);
                DLList.addNode(referenceNode, newChildNode, true);
                return new ShapePicComponent(parentContext, newChildNode, newChild, cellAnchor, number);
            }
        	default : {
                throw new UnsupportedOperationException();
            }
        }
    }

    @Override
    public void applyAttrsFromJSON(JSONObject attrs) {
        //
    }

    @Override
    public JSONObject createJSONAttrs(JSONObject attrs) throws Exception {
		return attrs;
    }
}
