/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.filter.ooxml.docx.components;

import org.json.JSONObject;
import com.openexchange.office.filter.core.DLNode;
import com.openexchange.office.filter.core.component.Component;
import com.openexchange.office.filter.core.component.ComponentContext;
import com.openexchange.office.filter.ooxml.OfficeOpenXMLOperationDocument;
import com.openexchange.office.filter.ooxml.components.OfficeOpenXMLComponent;
import com.openexchange.office.filter.ooxml.components.IShapeType;
import com.openexchange.office.filter.ooxml.components.ShapeType;

public class ShapeComponent_Root extends TextRun_Base implements IShapeType {

    protected ShapeType shapeType;
    protected OfficeOpenXMLComponent   shapeComponent;

    protected ShapeComponent_Root(ComponentContext<OfficeOpenXMLOperationDocument> parentContext, DLNode<Object> _rootShapeNode, int _componentNumber) {
        super(parentContext, _rootShapeNode, _componentNumber);
        shapeType = ShapeType.UNDEFINED;
    }

    @Override
	public Component<OfficeOpenXMLOperationDocument> getNextChildComponent(ComponentContext<OfficeOpenXMLOperationDocument> previousChildContext, Component<OfficeOpenXMLOperationDocument> previousChildComponent) {
	    return shapeComponent!=null?shapeComponent.getNextChildComponent(previousChildContext, previousChildComponent):null;
	}

    @Override
    public Component<OfficeOpenXMLOperationDocument> insertChildComponent(int number, JSONObject attrs, Component.Type type) throws Exception {
	    return shapeComponent!=null?shapeComponent.insertChildComponent(number, attrs, type):null;
	}

    @Override
    public void applyAttrsFromJSON(JSONObject attrs) throws Exception {
        if(shapeComponent!=null) {
            shapeComponent.applyAttrsFromJSON(attrs);
        }
        super.applyAttrsFromJSON(attrs);
    }

    @Override
    public JSONObject createJSONAttrs(JSONObject attrs) throws Exception {

        attrs = super.createJSONAttrs(attrs);
        if(shapeComponent!=null) {
            attrs = shapeComponent.createJSONAttrs(attrs);
        }
        return attrs;
    }

    @Override
    public ShapeType getType() {
    	return shapeType;
    }
}
