/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

/**
 *
 * @author sven.jacobi@open-xchange.com
 */

package com.openexchange.office.filter.ods.dom;

import org.apache.xml.serializer.SerializationHandler;
import org.odftoolkit.odfdom.IElementWriter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import com.openexchange.office.filter.core.DLList;
import com.openexchange.office.filter.core.INodeAccessor;
import com.openexchange.office.filter.odf.Namespaces;
import com.openexchange.office.filter.odf.SaxContextHandler;
import com.openexchange.office.filter.odt.dom.TextContentHelper;

public class HelpMessage implements IElementWriter, INodeAccessor, Cloneable {

    private Boolean display;
    private String title;

    private DLList<Object> content;

    public HelpMessage() {}

    public HelpMessage(Attributes attributes) {
        final String _display = attributes.getValue("table:display");
        if(_display!=null) {
            display = Boolean.parseBoolean(_display);
        }
        title = attributes.getValue("table:title");
	}

	public Boolean getDisplay() {
	    return display;
	}

	public void setDisplay(Boolean display) {
	    this.display = display;
	}

	public String getTitle() {
	    return title;
	}

	public void setTitle(String title) {
	    this.title = title;
	}

    @Override
    public DLList<Object> getContent() {
        if (content == null) {
            content = new DLList<Object>();
        }
        return content;
    }

	@Override
    public void writeObject(SerializationHandler output)
		throws SAXException {

        SaxContextHandler.startElement(output, Namespaces.TABLE, "help-message", "table:help-message");
        if(display!=null) {
            SaxContextHandler.addAttribute(output, Namespaces.TABLE, "display", "table:display", display.toString());
        }
        if(title!=null) {
            SaxContextHandler.addAttribute(output, Namespaces.TABLE, "title", "table:title", title);
        }
        TextContentHelper.write(output, getContent());
        SaxContextHandler.endElement(output, Namespaces.TABLE, "help-message", "table:help-message");
	}

    @Override
    protected HelpMessage clone() {
        try {
            final HelpMessage clone = (HelpMessage)super.clone();
            TextContentHelper.setSimpleText(clone, TextContentHelper.getSimpleText(this));
            return clone;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + TextContentHelper.getSimpleText(this).hashCode();
        result = prime * result + ((display == null) ? 0 : display.hashCode());
        result = prime * result + ((title == null) ? 0 : title.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        HelpMessage other = (HelpMessage) obj;
        if(!TextContentHelper.getSimpleText(other).equals(TextContentHelper.getSimpleText(this))) {
            return false;
        }
        if (display == null) {
            if (other.display != null)
                return false;
        } else if (!display.equals(other.display))
            return false;
        if (title == null) {
            if (other.title != null)
                return false;
        } else if (!title.equals(other.title))
            return false;
        return true;
    }
}
