/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.filter.ods.dom;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import org.apache.xerces.dom.ElementNSImpl;
import org.apache.xml.serializer.SerializationHandler;
import org.odftoolkit.odfdom.IElementWriter;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.w3c.dom.DOMException;
import org.xml.sax.SAXException;
import com.openexchange.office.filter.odf.Namespaces;
import com.openexchange.office.filter.odf.SaxContextHandler;

@SuppressWarnings("serial")
public class ConditionalFormats extends ElementNSImpl implements IElementWriter {

	private final Map<String, Condition> conditionalFormatList = new HashMap<String, Condition>();

	public ConditionalFormats(OdfFileDom ownerDocument)
		throws DOMException {
		super(ownerDocument, Namespaces.CALCEXT, "calcext:conditional-formats");
	}

	public Map<String, Condition> getConditionalFormatList() {
		return conditionalFormatList;
	}

	@Override
	public void writeObject(SerializationHandler output)
		throws SAXException {

		if(!conditionalFormatList.isEmpty()) {
			output.startElement(getNamespaceURI(), getLocalName(), getNodeName());
			SaxContextHandler.addAttributes(output, getAttributes(), null);
			final Map<String, List<Condition>>  map = new HashMap<String, List<Condition>>();
			final Iterator<Condition> conditionIter = conditionalFormatList.values().iterator();
			while(conditionIter.hasNext()) {
				final Condition condition = conditionIter.next();
				final String ranges = condition.getRanges().convertToString((SpreadsheetContent)this.getOwnerDocument(), true);
				List<Condition> conditionList = map.get(ranges);
				if(conditionList==null) {
					conditionList = new ArrayList<Condition>();
					map.put(ranges, conditionList);
	                conditionList.add(condition);
				}
				else {
				    int i = 0;
				    for(;i<conditionList.size();i++) {
				        if(conditionList.get(i).getPriority()>condition.getPriority()) {
				            break;
				        }
				    }
				    conditionList.add(i, condition);
				}
			}

			final Iterator<Entry<String, List<Condition>>> conditionEntryIter = map.entrySet().iterator();
			while(conditionEntryIter.hasNext()) {
				final Entry<String, List<Condition>> conditionEntry = conditionEntryIter.next();
				SaxContextHandler.startElement(output, Namespaces.CALCEXT, "conditional-format", "calcext:conditional-format");
				SaxContextHandler.addAttribute(output, Namespaces.CALCEXT, "target-range-address","calcext:target-range-address", conditionEntry.getKey());
				for(Condition condition:conditionEntry.getValue()) {
					condition.writeObject(output);
				}
				SaxContextHandler.endElement(output, Namespaces.CALCEXT, "conditional-format", "calcext:conditional-format");
			}
			output.endElement(getNamespaceURI(), getLocalName(), getNodeName());
		}
	}
}
