/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.filter.ods.dom;

import org.xml.sax.Attributes;
import com.openexchange.office.filter.odf.SaxContextHandler;

public class ColumnHandler extends SaxContextHandler {

    public ColumnHandler(SheetHandler sheetHandler, Attributes attributes, Column col) {
        super(sheetHandler);
        for(int i=0; i<attributes.getLength(); i++) {
            String localName = attributes.getLocalName(i);
            if(localName.equals("number-columns-repeated")) {
                col.setMax(col.getMin()+(Integer.valueOf(attributes.getValue(i))-1));
            }
            else if(localName.equals("default-cell-style-name")) {
                col.setDefaultCellStyle(attributes.getValue(i));
            }
            else if(localName.equals("visibility")) {
                col.setVisibility(Visibility.enumValueOf(attributes.getValue(i)));
            }
            else if(localName.equals("id")) {
                col.setId(attributes.getValue(i));
            }
        }

        // split first column from the column range, if it starts a new column group ("collapse" must be located on the leading column only)
        if ((col.getMin() < col.getMax()) && (col.getGroupCollapse() != null)) {
            Column startCol = col.splitBefore(col.getMin() + 1);
            sheetHandler.getSheet().getColumns().add(startCol);
            col.setGroupCollapse(null);
        }

        // set the maximum allowed number of columns to 16384 if a column greater than 1024 is used
        if(col.getMax()>=1024) {
            ((SpreadsheetContent)sheetHandler.getFileDom()).setMaxColumnCount(16384);
        }
    }
}
