/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

/**
 *
 * @author sven.jacobi@open-xchange.com
 */

package com.openexchange.office.filter.odp.dom;

import org.odftoolkit.odfdom.doc.OdfPresentationDocument;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.XMLReader;
import com.openexchange.office.filter.odf.DOMBuilder;
import com.openexchange.office.filter.odf.SaxContextHandler;
import com.openexchange.office.filter.odf.styles.AutomaticStylesHandler;
import com.openexchange.office.filter.odf.styles.FontFaceDeclsHandler;

/**
 * @author sven.jacobi@open-xchange.com
 */
public class PresentationContentHandler extends DOMBuilder {

    // the empty XML file to which nodes will be added
    private final PresentationContent content;
    private OdfPresentationDocument presentationDocument = null;

    public PresentationContentHandler(Node rootNode, XMLReader xmlReader) {
    	super(rootNode, xmlReader, (PresentationContent)rootNode);

        // Initialize starting DOM node
        content = (PresentationContent)rootNode;
        presentationDocument = content.getDocument();
        presentationDocument.setContentDom(content);
    }

    public PresentationContent getContentDom() {
    	return content;
    }

    @Override
    public SaxContextHandler startElement(Attributes attributes, String uri, String localName, String qName) {
    	if(qName.equals("office:automatic-styles")) {
    		return new AutomaticStylesHandler(this, content.getDocument().getStyleManager(), true);
    	}
    	else if(qName.equals("office:presentation")) {
    	    final Presentation presentation = new Presentation(getFileDom(), attributes);
    	    appendChild(presentation);
    	    content.setPresentation(presentation);
    	    return new PresentationHandler(this, presentation);
    	}
    	else if(qName.equals("office:font-face-decls")) {
    		return new FontFaceDeclsHandler(this, content.getDocument().getStyleManager(), true);
    	}
    	// if we come to this postion, the element is inserted normally into the dom...
    	return super.startElement(attributes, uri, localName, qName);
    }

    @Override
    public void endElement(String localName, String qName) {
    	if(qName.equals("office:automatic-styles")||qName.equals("office:font-face-decls")) {
    		// do nothing since we do not want this element to be inserted into the dom,
    		// this is done elsewhere
    		return;
    	}
    	super.endElement(localName, qName);
    }
}
