/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

/**
 * @author sven.jacobi@open-xchange.com
 */

package com.openexchange.office.filter.odf.styles;

import org.apache.xml.serializer.SerializationHandler;
import org.json.JSONObject;
import org.xml.sax.SAXException;
import com.openexchange.office.filter.odf.AttributeImpl;
import com.openexchange.office.filter.odf.AttributesImpl;
import com.openexchange.office.filter.odf.Namespaces;
import com.openexchange.office.filter.odf.OpAttrs;
import com.openexchange.office.filter.odf.SaxContextHandler;

final public class StrokeDashStyle extends StyleBase {

	public StrokeDashStyle(String name) {
		super(null, name, false, false);
	}

	public StrokeDashStyle(String name, AttributesImpl attributesImpl) {
		super(name, attributesImpl, false, false, false);
	}

	@Override
    protected void writeNameAttribute(SerializationHandler output) throws SAXException {
        output.addAttribute(Namespaces.DRAW, "name", "draw:name", "", getName());
    }

	@Override
	public String getQName() {
		return "draw:stroke-dash";
	}

	@Override
	public String getLocalName() {
		return "stroke-dash";
	}

	@Override
	public String getNamespace() {
		return Namespaces.DRAW;
	}

	@Override
	public void mergeAttrs(StyleBase styleBase) {
		//
	}

	@Override
	public void applyAttrs(StyleManager styleManager, JSONObject attrs) {
		//
	}

	@Override
	public void createAttrs(StyleManager styleManager, OpAttrs attrs) {
		// TODO Auto-generated method stub

	}

	@Override
	public void writeObject(SerializationHandler output) throws SAXException {
		SaxContextHandler.startElement(output, getNamespace(), getLocalName(), getQName());
		writeAttributes(output);
		SaxContextHandler.endElement(output, getNamespace(), getLocalName(), getQName());
	}

	@Override
	public StyleFamily getFamily() {
		return StyleFamily.STROKE_DASH;
	}

	@Override
	public StrokeDashStyle clone() {
		return (StrokeDashStyle)_clone();
	}

	@Override
	protected int _hashCode() {
		return 0;
	}

	@Override
	protected boolean _equals(StyleBase e) {
		return true;
	}

    static public String getStrokeDash(StyleManager styleManager, String dashStyle) {
        final StrokeDashStyle strokeDashStyle = new StrokeDashStyle(styleManager.getUniqueStyleName(StyleFamily.STROKE_DASH, false));
    	double length1 = 0.050;
    	Integer dots2 = null;
    	double length2 = 0.254;

    	switch(dashStyle) {
    		default:
    		case "dotted": {
	    		break;
	    	}
	    	case "dashed": {
	    		length1 = 0.254;
	    		break;
	    	}
	    	case "dashDot": {
	    		dots2 = 1;
	    		length1 = 0.254;
	    		length2 = 0.050;
	    		break;
	    	}
	    	case "dashDotDot": {
	    		dots2 = 2;
	    		length1 = 0.254;
	    		length2 = 0.050;
	    		break;
	    	}
    	}
    	strokeDashStyle.getAttributes().setValue(Namespaces.DRAW, "display-name", "draw:display-name", dashStyle);
    	strokeDashStyle.getAttributes().setValue(Namespaces.DRAW, "style", "draw:style", "rect");
    	strokeDashStyle.getAttributes().setValue(Namespaces.DRAW, "distance", "draw:distance", "0.050cm");
		strokeDashStyle.getAttributes().setValue(Namespaces.DRAW, "dots1", "draw:dots1", "1");
		strokeDashStyle.getAttributes().setValue(Namespaces.DRAW, "dots1-length", "draw:dots1-length", Double.valueOf(length1).toString() + "cm");
		if(dots2!=null) {
			strokeDashStyle.getAttributes().setValue(Namespaces.DRAW, "dots2", "draw:dots2", "1");
			strokeDashStyle.getAttributes().setValue(Namespaces.DRAW, "dots2-length", "draw:dots2-length", Double.valueOf(length2).toString() + "cm");
		}
		final String existingStyleId = styleManager.getExistingStyleIdForStyleBase(strokeDashStyle);
		if(existingStyleId!=null) {
			return existingStyleId;
		}
		styleManager.addStyle(strokeDashStyle);
		return strokeDashStyle.getName();
    }

	static public String getStrokeDashEnumFromStyleName(StyleManager styleManager, AttributeImpl dashStyle) {
		if(dashStyle==null) {
			return "dotted";
		}
		final StyleBase styleBase = styleManager.getStyle(dashStyle.getValue(), StyleFamily.STROKE_DASH, false);
		if(!(styleBase instanceof StrokeDashStyle)) {
			return "dotted";
		}
		final int dots2 = styleBase.getInteger("draw:dots2", 0);
        if(dots2==0) {
            final String l1 = styleBase.getAttribute("draw:dots1-length");
            if(l1!=null) {
                final Integer length1 = AttributesImpl.normalizeLength(l1, true);
    			if(length1!=null&&length1>100) {
    				return "dashed";
    			}
            }
		}
		else if(dots2==1) {
			return "dashDot";
		}
		else if(dots2==2) {
			return "dashDotDot";
		}
		return "dotted";
	}
}
