/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */


/**
 * @author sven.jacobi@open-xchange.com
 */

package com.openexchange.office.filter.odf;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.xml.parsers.DocumentBuilder;
import org.apache.commons.codec.binary.Base64InputStream;
import org.apache.commons.codec.binary.Base64OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.xml.serializer.SerializationHandler;
import org.odftoolkit.odfdom.pkg.OdfPackage;
import org.w3c.dom.Document;
import org.xml.sax.Attributes;

abstract public class ElementToBase64Handler extends SaxContextHandler {

    final StringBuffer buffer;
    final SaxContextHandler parentContextHandler;

	public ElementToBase64Handler(SaxContextHandler parentContextHandler, Attributes attributes, String uri, String localName, String qName) {
		super(parentContextHandler);

		this.buffer = new StringBuffer();
		this.parentContextHandler = parentContextHandler;

		startElement(attributes, uri, localName, qName);
	}

	abstract protected void setBase64ElementData(String data);

	@Override
	public void characters(String characters) {
	    buffer.append(characters);
	}

	@Override
    public SaxContextHandler startElement(Attributes attributes, String uri, String localName, String qName) {
        OdfOperationDoc.abortOnLowMemory(getFileDom());
		buffer.append('<');
		buffer.append(qName);
		for(int i=0; i<attributes.getLength(); i++) {
		    buffer.append(' ');
		    buffer.append(attributes.getQName(i));
		    buffer.append("=\"");
		    buffer.append(attributes.getValue(i));
		    buffer.append("\"");
		}
		buffer.append('>');
    	return this;
	}

    @Override
    public void endElement(String localName, String qName) {
        buffer.append("</");
        buffer.append(qName);
        buffer.append(">");
    }

    @Override
    public void endContext(String qName, String characters) {
        if(getContextHandler()==parentContextHandler) {
            endElement(null, qName);
            final ByteArrayOutputStream output = new ByteArrayOutputStream();
            final Base64OutputStream b64os = new Base64OutputStream(output);
            GZIPOutputStream gzip;
            try {
                gzip = new GZIPOutputStream(b64os);
                final String data = buffer.toString();
                gzip.write(data.getBytes());
                IOUtils.closeQuietly(gzip);
                output.close();
            } catch (IOException e) {
                // ohoh
            }
            IOUtils.closeQuietly(b64os);
            setBase64ElementData(output.toString());
            IOUtils.closeQuietly(output);
        }
    }

    public static void writeString(SerializationHandler output, String base64Data) {
        if(base64Data!=null) {
            final ByteArrayInputStream input = new ByteArrayInputStream(base64Data.getBytes());
            final Base64InputStream b64is = new Base64InputStream(input);
            GZIPInputStream gzip;
            try {
                gzip = new GZIPInputStream(b64is);
                output.getWriter().write(IOUtils.toString(gzip, "UTF-8"));
                IOUtils.closeQuietly(gzip);
            } catch (IOException e) {
                // ohoh
            }
            IOUtils.closeQuietly(b64is);
            IOUtils.closeQuietly(input);
        }
    }

    public static Document getDOMFromBase64Data(String base64Data) {
        Document doc = null;
        if(base64Data!=null&&!base64Data.isEmpty()) {
            DocumentBuilder builder;
            ByteArrayInputStream input = null;
            Base64InputStream b64is = null;
            GZIPInputStream gzip = null;
            try {
                builder = OdfPackage.getDocumentBuilder(false);
                input = new ByteArrayInputStream(base64Data.getBytes());
                b64is = new Base64InputStream(input);
                gzip = new GZIPInputStream(b64is);
                doc = builder.parse(gzip);
            } catch (Exception e) {
                //
            }
            finally {
                IOUtils.closeQuietly(gzip);
                IOUtils.closeQuietly(b64is);
                IOUtils.closeQuietly(input);
            }
        }
        return doc;
    }
}
