/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.filter.odf;

import org.xml.sax.Attributes;

/**
 * @author sven.jacobi@open-xchange.com
 */
public class ConfigItemMapEntryHandler extends SaxContextHandler {

	final private ConfigItemMapEntry configItemMapEntry;

	public ConfigItemMapEntryHandler(SaxContextHandler parentContextHandler, ConfigItemMapEntry configItemMapEntry) {
   		super(parentContextHandler);

   		this.configItemMapEntry = configItemMapEntry;
    }

    @Override
    public SaxContextHandler startElement(Attributes attributes, String uri, String localName, String qName) {
    	if(qName.equals("config:config-item")) {
    		final String name = attributes.getValue("config:name");
    		if(name!=null&&!name.isEmpty()) {
    			final ConfigItem configItem = new ConfigItem(name, attributes);
    			configItemMapEntry.getItems().put(name, configItem);
    			return new ConfigItemHandler(this, configItem);
    		}
    	}
    	else if(qName.equals("config:config-item-map-indexed")) {
    		final String name = attributes.getValue("config:name");
    		if(name!=null&&!name.isEmpty()) {
    			final ConfigItemMapIndexed configItemMapIndexed = new ConfigItemMapIndexed(name);
    			configItemMapEntry.getItems().put(name,  configItemMapIndexed);
    			return new ConfigItemMapIndexedHandler(this, configItemMapIndexed);
    		}
    	}
    	else if(qName.equals("config:config-item-set")) {
    		final String name = attributes.getValue("config:name");
    		if(name!=null&&!name.isEmpty()) {
    			final ConfigItemSet configItemSet = new ConfigItemSet(name);
    			configItemMapEntry.getItems().put(name, configItemSet);
    			return new ConfigItemSetHandler(this, configItemSet);
    		}
    	}
    	else if(qName.equals("config:config-item-map-named")) {
    		final String name = attributes.getValue("config:name");
    		if(name!=null&&!name.isEmpty()) {
    			final ConfigItemMapNamed configItemMapNamed = new ConfigItemMapNamed(name, attributes);
    			configItemMapEntry.getItems().put(name, configItemMapNamed);
    			return new ConfigItemMapNamedHandler(this, configItemMapNamed);
    		}
    	}
     	return this;
	}
}
