/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.filter.api;

public class FilterException extends RuntimeException {

    /**
     *
     */
    private static final long serialVersionUID = 1L;

    public enum ErrorCode {
        CRITICAL_ERROR,
        WRONG_PASSWORD,
        UNSUPPORTED_ENCRYPTION_USED,
        COMPLEXITY_TOO_HIGH,
        MEMORY_USAGE_TOO_HIGH,
        MEMORY_USAGE_MIN_FREE_HEAP_SPACE_REACHED,
        UNSUPPORTED_OPERATION_USED,
        STRICT_OOXML_NOT_SUPPORTED,
        FEATURE_NOT_SUPPORTED
    };

    public static String ST_MAX_SHEET_COUNT_EXCEEDED = "MAX_SHEET_COUNT_EXCEEDED";
    public static String ST_FRAME_ATTACHED_TO_FRAME_NOT_SUPPORTED = "FRAME_ATTACHED_TO_FRAME_IS_NOT_SUPPORTED";
    public static String ST_MEDIATYPE_NOT_SUPPORTED = "MEDIATYPE_NOT_SUPPORTED";

    final private ErrorCode errorCode;
    final private Object value;
    private String subType = null;
    private int operationCount = 0;

    public FilterException(String message, ErrorCode eCode) {
        super(message);
        errorCode = eCode;
        value = null;
    }

    public FilterException(String message, ErrorCode eCode, Object value) {
        super(message);
        errorCode = eCode;
        this.value = value;
    }

    public FilterException(String message, Throwable e, ErrorCode eCode) {
        super(message, e);
        setStackTrace(e.getStackTrace());
        errorCode = eCode;
        value = null;
    }

    public FilterException(String message, Throwable e, ErrorCode eCode, Object value) {
        super(message, e);
        setStackTrace(e.getStackTrace());
        errorCode = eCode;
        this.value = value;
    }

    public FilterException(Throwable e, ErrorCode eCode) {
        super(e);
        setStackTrace(e.getStackTrace());
        errorCode = eCode;
        value = null;
    }

    public FilterException(Throwable e, ErrorCode eCode, Object value) {
        super(e);
        setStackTrace(e.getStackTrace());
        errorCode = eCode;
        this.value = value;
    }

    public ErrorCode getErrorcode() {
        return errorCode;
    }

    public Object getValue() {
        return value;
    }

    public String getSubType() {
    	return subType;
    }

    public void setSubType(String v) {
    	subType = v;
    }
    public int getOperationCount() {
    	return operationCount;
    }
    public void setOperationCount(int count) {
    	operationCount = count;
    }
}
