package com.openexchange.office.documents.impl.osgi;

import com.hazelcast.core.HazelcastInstance;
import com.openexchange.office.documents.DocRequester;
import com.openexchange.office.documents.DocumentRequestProcessor;
import com.openexchange.office.documents.Documents;
import com.openexchange.office.documents.hazelcast.serialization.PortableDocRequestFactory;
import com.openexchange.office.documents.impl.DocRequesterImpl;
import com.openexchange.office.documents.impl.DocumentRequestProcessorImpl;
import com.openexchange.office.documents.impl.DocumentsImpl;
import com.openexchange.office.tools.logging.v2.ELogLevel;
import com.openexchange.office.tools.logging.v2.impl.Logger;
import com.openexchange.office.tools.logging.v2.impl.Slf4JLogger;
import com.openexchange.office.tools.osgi.ActivatorBase;
import java.util.List;

//=============================================================================
public class Activator extends ActivatorBase
{
	//-------------------------------------------------------------------------   
    private static final String SERVICE_NAME = "com.openexchange.office.documents.impl";

	//-------------------------------------------------------------------------   
    private static final Logger LOG = Slf4JLogger.create(Activator.class);

	//-------------------------------------------------------------------------   
    public Activator ()
        throws Exception
    {
        super (SERVICE_NAME);
    }

    //-------------------------------------------------------------------------   
    @Override
    protected void listMandatoryServiceImports(final List< Class< ? >> lServices)
    	throws Exception
    {
        lServices.add (HazelcastInstance.class);
    }

    //-------------------------------------------------------------------------   
    @Override
    protected void listOptionalServiceImports(final List< Class< ? >> lServices)
    	throws Exception
    {
    	// no optional services
    }

    //-------------------------------------------------------------------------   
    @Override
    protected void activate()
    	throws Exception
    {
        LOG.forLevel(ELogLevel.E_DEBUG).withMessage("Starting " + SERVICE_NAME).log();

        registerService(Documents.class, new DocumentsImpl());
        registerService(DocumentRequestProcessor.class, new DocumentRequestProcessorImpl());
        registerService(DocRequester.class, new DocRequesterImpl());
    }

    //-------------------------------------------------------------------------   
    @Override
    protected void deactivate()
    	throws Exception
    {
        LOG.forLevel(ELogLevel.E_DEBUG).withMessage("Stopping " + SERVICE_NAME).log();

        // de-registration of services is done by base class ...
        // further actions not needed
    }

}
