package com.openexchange.office.documents.hazelcast.osgi;

import com.hazelcast.core.HazelcastInstance;
import com.openexchange.hazelcast.serialization.CustomPortableFactory;
import com.openexchange.office.documents.hazelcast.serialization.PortableDocRequestFactory;
import com.openexchange.office.tools.logging.v2.ELogLevel;
import com.openexchange.office.tools.logging.v2.impl.Logger;
import com.openexchange.office.tools.logging.v2.impl.Slf4JLogger;
import com.openexchange.office.tools.osgi.ActivatorBase;
import java.util.List;

//=============================================================================
public class Activator extends ActivatorBase
{
	//-------------------------------------------------------------------------   
    private static final String SERVICE_NAME = "com.openexchange.office.documents.hazelcast";

	//-------------------------------------------------------------------------   
    private static final Logger LOG = Slf4JLogger.create(Activator.class);

	//-------------------------------------------------------------------------   
    public Activator ()
        throws Exception
    {
        super (SERVICE_NAME);
    }

    //-------------------------------------------------------------------------   
    @Override
    protected void listMandatoryServiceImports(final List< Class< ? >> lServices)
    	throws Exception
    {
        lServices.add (HazelcastInstance.class);
    }

    //-------------------------------------------------------------------------   
    @Override
    protected void listOptionalServiceImports(final List< Class< ? >> lServices)
    	throws Exception
    {
    	// no optional services
    }

    //-------------------------------------------------------------------------   
    @Override
    protected void activate()
    	throws Exception
    {
        LOG.forLevel(ELogLevel.E_DEBUG).withMessage("Starting " + SERVICE_NAME).log();

		registerService(CustomPortableFactory.class, new PortableDocRequestFactory());
    }

    //-------------------------------------------------------------------------   
    @Override
    protected void deactivate()
    	throws Exception
    {
        LOG.forLevel(ELogLevel.E_DEBUG).withMessage("Stopping " + SERVICE_NAME).log();

        // de-registration of services is done by base class ...
        // further actions not needed
    }

}
