package com.openexchange.office.document;

import com.openexchange.office.filter.api.IExporter;
import com.openexchange.office.filter.api.IImporter;
import com.openexchange.office.tools.doc.DocumentFormat;
import com.openexchange.office.tools.osgi.ServiceLookupRegistry;
import com.openexchange.office.tools.osgi.ServiceLookupRegistryService;
import com.openexchange.server.ServiceLookup;


public class ImExportHelper {

    private final static org.apache.commons.logging.Log LOG = com.openexchange.log.LogFactory.getLog(ImExportHelper.class);

    /**
     * Provides the importer for the current document.
     *
     * @return The Importer for the current file helper object
     */
    public static IImporter getImporter(final ServiceLookup servicesDEPRECATED, final DocFileHelper fileHelper) {
        IImporter importer = null;

        if (null != fileHelper) {
            importer = ImExportHelper.getImporterService(null, fileHelper.getDocumentFormat());
        }

        return importer;
    }

    /**
     * Provides the exporter for the current document depending on the format.
     *
     * @return The Exporter for the current file helper object
     */
    public static IExporter getExporter(final ServiceLookup servicesDEPRECATED, final DocFileHelper fileHelper) {
        IExporter exporter = null;

        if (null != fileHelper) {
            exporter = ImExportHelper.getExporterService(null, fileHelper.getDocumentFormat());
        }

        return exporter;
    }

    public static IImporter getImporterService(final ServiceLookup servicesDEPRECATED, final DocumentFormat documentFormat) {
        IImporter importer = null;
        final ServiceLookupRegistryService services = ServiceLookupRegistryService.getInstance();

        switch (documentFormat) {
            case DOCX: {
                importer = services.getService(com.openexchange.office.filter.ooxml.docx.Importer.class);
                break;
            }

            case PPTX: {
                importer = services.getService(com.openexchange.office.filter.ooxml.pptx.Importer.class);
                break;
            }

            case XLSX: {
                importer = services.getService(com.openexchange.office.filter.ooxml.xlsx.Importer.class);
                break;
            }

            case ODT: {
                importer = services.getService(com.openexchange.office.filter.odt.dom.Importer.class);
                break;
            }
            case ODP: {
                importer = services.getService(com.openexchange.office.filter.odp.dom.Importer.class);
                break;
            }
            case ODS: {
                importer = services.getService(com.openexchange.office.filter.ods.dom.Importer.class);
                break;
            }

            case NONE:
            case ODG:
            default: {
            	LOG.warn("RT connection: There is no import filter service available for the document format: " + documentFormat.name());
                break;
            }
        }

        return importer;
    }

    public static IExporter getExporterService(final ServiceLookup servicesDEPRECATED, final DocumentFormat documentFormat) {
        IExporter exporter = null;
        final ServiceLookupRegistry services = ServiceLookupRegistry.get();

        switch (documentFormat) {
            case DOCX: {
                exporter = services.getService(com.openexchange.office.filter.ooxml.docx.Exporter.class);
                break;
            }

            case PPTX: {
                exporter = services.getService(com.openexchange.office.filter.ooxml.pptx.Exporter.class);
                break;
            }

            case XLSX: {
                exporter = services.getService(com.openexchange.office.filter.ooxml.xlsx.Exporter.class);
                break;
            }

            case ODT:
            case ODP:
            case ODS: {
                exporter = services.getService(com.openexchange.office.filter.odf.Exporter.class);
                break;
            }

            case NONE:
            case ODG:
            default: {
            	LOG.warn("RT connection: There is no export filter service available for the document format: " + documentFormat.name());
                break;
            }
        }

        return exporter;
    }
}
