/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.office.dcs.registry.config;

import java.util.HashMap;
import java.util.Map;

//=============================================================================
public class DCSRegistryItem {
    //-------------------------------------------------------------------------
    public static final String DCS_KEY_ID           = "id"       ;
    public static final String DCS_KEY_INTERFACE    = "interface";
    public static final String DCS_KEY_HOST         = "host"     ;
    public static final String DCS_KEY_PORT_JMS     = "port.jms" ;
    public static final String DCS_KEY_PORT_JMS_SSL = "port.jmsssl" ;
    public static final String DCS_KEY_USE_SSL      = "usessl" ;

    private final Map<String, Object> content = new HashMap<>();

    private String id;

    //-------------------------------------------------------------------------
	public DCSRegistryItem () {}

	//-------------------------------------------------------------------------
	public synchronized void setID (final String sID) {
	    this.id = sID;
	    content.put (DCS_KEY_ID, sID);
	}

	//-------------------------------------------------------------------------
    public synchronized String getID () {
        return (String) content.get(DCS_KEY_ID);
    }

    //-------------------------------------------------------------------------
    public synchronized void setHost (final String sHost) {
        content.put (DCS_KEY_HOST, sHost);
    }

    //-------------------------------------------------------------------------
    public synchronized String getHost () {
        return (String) content.get(DCS_KEY_HOST);
    }

    //-------------------------------------------------------------------------
    public synchronized void setInterface (final String sInterface) {
        content.put(DCS_KEY_INTERFACE, sInterface);
    }

    //-------------------------------------------------------------------------
    public synchronized String getInterface () {
        return (String) content.get(DCS_KEY_INTERFACE);
    }

    //-------------------------------------------------------------------------
    public synchronized void setJMSPort(final Integer nPort) {
        content.put (DCS_KEY_PORT_JMS, nPort);
    }

    //-------------------------------------------------------------------------
    public synchronized Integer getJMSPort () {
        return (Integer) content.get(DCS_KEY_PORT_JMS);
    }

    //-------------------------------------------------------------------------
    public synchronized void setUseSSL(final Boolean useSSL) {
        content.put (DCS_KEY_USE_SSL, useSSL);
    }

    //-------------------------------------------------------------------------
    public synchronized Boolean isUseSSL() {
        return (Boolean) content.get(DCS_KEY_USE_SSL);
    }


    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((id == null) ? 0 : id.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        DCSRegistryItem other = (DCSRegistryItem) obj;
        if (id == null) {
            if (other.id != null)
                return false;
        } else if (!id.equals(other.id))
            return false;
        return true;
    }
}
