package com.openexchange.office.dcs.registry.config;

import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.UriComponentsBuilder;
import com.openexchange.config.ConfigurationService;
import com.openexchange.office.tools.osgi.ServiceLookupRegistry;

public class DCSConfig {

    private static final Logger log = LoggerFactory.getLogger(DCSConfig.class);

    final public static String CFGKEY_PREFIX_DCS = "com.openexchange.dcs";
    final public static String DCS_KEY_ID = CFGKEY_PREFIX_DCS + ".id";
    final public static String DCS_KEY_INTERFACE = CFGKEY_PREFIX_DCS + ".interface";
    final public static String DCS_KEY_JMSPORT = CFGKEY_PREFIX_DCS + ".port.jms";

    private static final String DCS_INTERFACE_DEFAULT = "127.0.0.1";
    private static final String DCS_HOST_DEFAULT = "127.0.0.1";
    private static final int DCS_JMSPORT_DEFAULT = 61616;

    public String getId() {
        return getBrokerInterface() + ":" + getBrokerPort();
    }

    public String getBrokerInterface() {
        String brokerInterface = mem_Config().getProperty(DCS_KEY_INTERFACE);
        return (StringUtils.isNotBlank(brokerInterface) ? brokerInterface : DCS_INTERFACE_DEFAULT);
    }

    public String getBrokerHost() {
        try {
            final InetAddress address = InetAddress.getLocalHost();
            return address.getHostAddress();
        } catch (UnknownHostException ex) {
            log.warn("Cannot determine host address, using default host address 127.0.0.1");
            return DCS_HOST_DEFAULT;
        }
    }

    public int getBrokerPort() {
        String portAsStr = mem_Config().getProperty(DCS_KEY_JMSPORT);
        return (StringUtils.isNotBlank(portAsStr) ? Integer.parseInt(portAsStr) : DCS_JMSPORT_DEFAULT);
    }

    public URI toUri() {
        try {
        	final URI res = URI.create(UriComponentsBuilder.newInstance()
        		.scheme("tcp")
        		.host(getBrokerInterface())
        		.port(getBrokerPort()).toUriString());
            return res;
        } catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public String toString() {
        return "DCS [id=" + getId() + ", interface=" + getBrokerInterface() + ", host=" + getBrokerHost() + ", port=" + getBrokerPort() + "]";
    }

    public static  ConfigurationService mem_Config () {
        final ConfigurationService aConfig = ServiceLookupRegistry.get ().getService(ConfigurationService.class);
        return aConfig;
    }
}
