/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.handler.invocation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.MethodParameter;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.handler.invocation.AsyncHandlerMethodReturnValueHandler;
import org.springframework.messaging.handler.invocation.HandlerMethodReturnValueHandler;
import org.springframework.util.Assert;
import org.springframework.util.concurrent.ListenableFuture;

public class HandlerMethodReturnValueHandlerComposite
implements AsyncHandlerMethodReturnValueHandler {
    public static final Log defaultLogger = LogFactory.getLog(HandlerMethodReturnValueHandlerComposite.class);
    private Log logger = defaultLogger;
    private final List<HandlerMethodReturnValueHandler> returnValueHandlers = new ArrayList<HandlerMethodReturnValueHandler>();

    public void setLogger(Log logger) {
        this.logger = logger;
    }

    public Log getLogger() {
        return this.logger;
    }

    public List<HandlerMethodReturnValueHandler> getReturnValueHandlers() {
        return Collections.unmodifiableList(this.returnValueHandlers);
    }

    public void clear() {
        this.returnValueHandlers.clear();
    }

    public HandlerMethodReturnValueHandlerComposite addHandler(HandlerMethodReturnValueHandler returnValueHandler) {
        this.returnValueHandlers.add(returnValueHandler);
        return this;
    }

    public HandlerMethodReturnValueHandlerComposite addHandlers(@Nullable List<? extends HandlerMethodReturnValueHandler> handlers) {
        if (handlers != null) {
            this.returnValueHandlers.addAll(handlers);
        }
        return this;
    }

    @Override
    public boolean supportsReturnType(MethodParameter returnType) {
        return this.getReturnValueHandler(returnType) != null;
    }

    @Nullable
    private HandlerMethodReturnValueHandler getReturnValueHandler(MethodParameter returnType) {
        for (int i = 0; i < this.returnValueHandlers.size(); ++i) {
            HandlerMethodReturnValueHandler handler = this.returnValueHandlers.get(i);
            if (!handler.supportsReturnType(returnType)) continue;
            return handler;
        }
        return null;
    }

    @Override
    public void handleReturnValue(@Nullable Object returnValue, MethodParameter returnType, Message<?> message) throws Exception {
        HandlerMethodReturnValueHandler handler = this.getReturnValueHandler(returnType);
        if (handler == null) {
            throw new IllegalStateException("No handler for return value type: " + returnType.getParameterType());
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Processing return value with " + handler);
        }
        handler.handleReturnValue(returnValue, returnType, message);
    }

    @Override
    public boolean isAsyncReturnValue(Object returnValue, MethodParameter returnType) {
        HandlerMethodReturnValueHandler handler = this.getReturnValueHandler(returnType);
        return handler instanceof AsyncHandlerMethodReturnValueHandler && ((AsyncHandlerMethodReturnValueHandler)handler).isAsyncReturnValue(returnValue, returnType);
    }

    @Override
    @Nullable
    public ListenableFuture<?> toListenableFuture(Object returnValue, MethodParameter returnType) {
        HandlerMethodReturnValueHandler handler = this.getReturnValueHandler(returnType);
        Assert.state(handler instanceof AsyncHandlerMethodReturnValueHandler, "AsyncHandlerMethodReturnValueHandler required");
        return ((AsyncHandlerMethodReturnValueHandler)handler).toListenableFuture(returnValue, returnType);
    }
}

