/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.function;

import com.ibm.icu.text.Normalizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.wst.xml.xpath2.api.DynamicContext;
import org.eclipse.wst.xml.xpath2.api.EvaluationContext;
import org.eclipse.wst.xml.xpath2.api.ResultSequence;
import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.internal.SeqType;
import org.eclipse.wst.xml.xpath2.processor.internal.function.Function;
import org.eclipse.wst.xml.xpath2.processor.internal.types.QName;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSString;

public class FnNormalizeUnicode
extends Function {
    private static Collection<SeqType> _expected_args = null;
    private static W3CNormalizer normalizer = null;

    public FnNormalizeUnicode() {
        super(new QName("normalize-unicode"), 1, 2);
    }

    @Override
    public ResultSequence evaluate(Collection<ResultSequence> args, EvaluationContext ec) throws DynamicError {
        return FnNormalizeUnicode.normalize_unicode(args, ec.getDynamicContext());
    }

    public static ResultSequence normalize_unicode(Collection<ResultSequence> args, DynamicContext d_context) throws DynamicError {
        assert (args.size() >= 1 && args.size() <= 2);
        Collection<ResultSequence> cargs = Function.convert_arguments(args, FnNormalizeUnicode.expected_args());
        Iterator<ResultSequence> cargsIterator = cargs.iterator();
        ResultSequence arg1 = cargsIterator.next();
        String normalizationType = "NFC";
        if (cargsIterator.hasNext()) {
            ResultSequence arg2 = cargsIterator.next();
            normalizationType = arg2.empty() ? "" : ((XSString)arg2.first()).value().trim().toUpperCase();
        }
        String argument = "";
        if (!arg1.empty()) {
            argument = ((XSString)arg1.first()).value();
        }
        String normalized = normalizationType.equals("") ? argument : FnNormalizeUnicode.getNormalizer().normalize(argument, normalizationType);
        return new XSString(normalized);
    }

    private static W3CNormalizer getNormalizer() {
        ClassLoader classLoader;
        if (normalizer == null && (normalizer = FnNormalizeUnicode.createICUNormalizer(classLoader = Thread.currentThread().getContextClassLoader())) == null) {
            normalizer = new FailingNormalizer();
        }
        return normalizer;
    }

    private static W3CNormalizer createICUNormalizer(ClassLoader classLoader) {
        try {
            if (classLoader.loadClass("com.ibm.icu.text.Normalizer") != null) {
                return new ICUNormalizer();
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return null;
    }

    public static synchronized Collection<SeqType> expected_args() {
        if (_expected_args == null) {
            _expected_args = new ArrayList<SeqType>();
            _expected_args.add(new SeqType(new XSString(), 3));
            _expected_args.add(new SeqType(new XSString(), 0));
        }
        return _expected_args;
    }

    static class FailingNormalizer
    implements W3CNormalizer {
        FailingNormalizer() {
        }

        @Override
        public String normalize(String argument, String normalizationForm) throws DynamicError {
            throw DynamicError.unsupported_normalization_form("Can't normalize to form " + normalizationForm + ": No ICU Library or Java 6 found. 'normalize-unicode' requires either 'com.ibm.icu.text.Normalizer' or 'java.text.Normalizer' on the classpath");
        }
    }

    static class ICUNormalizer
    implements W3CNormalizer {
        private Map<String, Normalizer.Mode> modeMap = new HashMap<String, Normalizer.Mode>();

        ICUNormalizer() {
            this.modeMap.put("NFC", Normalizer.NFC);
            this.modeMap.put("NFD", Normalizer.NFD);
            this.modeMap.put("NFKC", Normalizer.NFKC);
            this.modeMap.put("NFKD", Normalizer.NFKD);
        }

        @Override
        public String normalize(String argument, String normalizationForm) throws DynamicError {
            Normalizer.Mode mode = this.modeMap.get(normalizationForm);
            if (mode != null) {
                return Normalizer.normalize((String)argument, (Normalizer.Mode)mode);
            }
            throw DynamicError.unsupported_normalization_form(normalizationForm);
        }
    }

    public static interface W3CNormalizer {
        public String normalize(String var1, String var2) throws DynamicError;
    }
}

