package com.openexchange.office.tools.osgi;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

@SuppressWarnings("unused")
public class ServiceLookupRegistryService {
	private static ServiceLookupRegistryService INSTANCE = new ServiceLookupRegistryService();
	
	/**
	 * For easy mocking
	 * @param instance Mocked instance of {@link ServiceLookupRegistryService}
	 */
	public static void init(ServiceLookupRegistryService instance) {
		INSTANCE = instance;
	}
	
	public static ServiceLookupRegistryService getInstance() {
		return INSTANCE;
	}
	
	private Map<Class<?>, Object> services = new HashMap<>();
	
	public ServiceLookupRegistryService() {
	}

	public ServiceLookupRegistryService(Map<Class<?>, Object> services) {
		this.services = services;
	}
		
	public <T> T getService(Class<T> clazz) {
		@SuppressWarnings("unchecked")
		T res = (T) services.get(clazz);
		if (res == null) {
			res = getServiceFromServiceLookupRegistry(clazz, false);
			services.put(clazz, res);
		}
		return res;
	}	

	public <T> T getOptionalService(Class<T> clazz) {
		@SuppressWarnings("unchecked")
		T res = (T) services.get(clazz);
		if (res == null) {
			res = getServiceFromServiceLookupRegistry(clazz, true);
			services.put(clazz, res);
		}
		return res;		
	}	
	
	public Object registerAdditionalService(Class<?> clazz, Object service) {
		return services.put(clazz, service);
	}
	
	private <T> T getServiceFromServiceLookupRegistry(Class<T> clazz, boolean optional) {
		if (optional) {
			return ServiceLookupRegistry.get().getOptionalService(clazz);
		}
		return ServiceLookupRegistry.get().getService(clazz);
	}	
}
