/**
 * OPEN-XCHANGE legal information
 *
 * All intellectual property rights in the Software are protected by
 * international copyright laws.
 *
 *
 * In some countries OX, OX Open-Xchange, open xchange and OXtender
 * as well as the corresponding Logos OX Open-Xchange and OX are registered
 * trademarks of the OX Software GmbH group of companies.
 * The use of the Logos is not covered by the GNU General Public License.
 * Instead, you are allowed to use these Logos according to the terms and
 * conditions of the Creative Commons License, Version 2.5, Attribution,
 * Non-commercial, ShareAlike, and the interpretation of the term
 * Non-commercial applicable to the aforementioned license is published
 * on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 * Please make sure that third-party modules and libraries are used
 * according to their respective licenses.
 *
 * Any modifications to this package must retain all copyright notices
 * of the original copyright holder(s) for the original code used.
 *
 * After any such modifications, the original and derivative code shall remain
 * under the copyright of the copyright holder(s) and/or original author(s)per
 * the Attribution and Assignment Agreement that can be located at
 * http://www.open-xchange.com/EN/developer/. The contributing author shall be
 * given Attribution for the derivative code and a license granting use.
 *
 *  Copyright (C) 2016-2020 OX Software GmbH
 *  Mail: info@open-xchange.com
 *
 *
 *  This program is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License, Version 2 as published
 *  by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *  or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *  for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc., 59
 *  Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */
package com.openexchange.office.tools.logging.v2;

import java.io.InputStream;
import java.net.URL;
import java.util.concurrent.CountDownLatch;

import org.apache.commons.io.IOUtils;
import org.slf4j.LoggerFactory;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;

//=============================================================================
public class LogProxy
{
    //-------------------------------------------------------------------------
    public static final String LOGCONF_URL = "classpath:/com/openxchange/office_communication/tools/logging/res/logback-proxy.xml";

    //-------------------------------------------------------------------------
    public static final String CFGKEY_PROXY_INTERFACE = "log.proxy.interface";
    public static final String CFGKEY_PROXY_HOST      = "log.proxy.host"     ;
    public static final String CFGKEY_PROXY_PORT      = "log.proxy.port"     ;
    
    //-------------------------------------------------------------------------
    public LogProxy ()
        throws Exception
    {}

    //-------------------------------------------------------------------------
    public synchronized void setInterface (final String sInterface)
        throws Exception
    {
    	m_sInterface = sInterface;
    }

    //-------------------------------------------------------------------------
    public synchronized void setPort (final int nPort)
        throws Exception
    {
    	m_nPort = nPort;
    }
    
    //-------------------------------------------------------------------------
    public /*no synchronized here!*/ void start ()
    	throws Exception
    {
    	String sInterface = null;
    	String sPort      = null;
    	synchronized(this)
    	{
    		if (m_aRunSync != null)
    			return;
    		
    		m_aRunSync = new CountDownLatch (1);
    		
    		sInterface = m_sInterface;
    		sPort      = Integer.toString(m_nPort);
    	}
    	
    	final LoggerContext     aContext      = (LoggerContext) LoggerFactory.getILoggerFactory();
    	final JoranConfigurator aConfigurator = new JoranConfigurator();

    	aContext     .reset      ();
    	aContext     .putProperty(CFGKEY_PROXY_INTERFACE, sInterface);
    	aContext     .putProperty(CFGKEY_PROXY_PORT     , sPort     );
    	aConfigurator.setContext (aContext);
    	
    	InputStream aConfigStream = null;
    	try
    	{
    		aConfigStream = new URL (LOGCONF_URL).openStream();
    		aConfigurator.doConfigure(aConfigStream);
    	}
    	finally
    	{
    		IOUtils.closeQuietly(aConfigStream);
    	}
    	
    	System.out.println ("LogProxy.start : start ...\n[\ninterface="+sInterface+",\nport="+sPort+"\n]");
    	aContext.start();
    	System.out.println ("LogProxy.start : running ...\n[\ninterface="+sInterface+",\nport="+sPort+"\n]");
    	
    	synchronized(this)
    	{
    		m_aContext      = aContext;
    		m_aConfigurator = aConfigurator;
    	}
    }

    //-------------------------------------------------------------------------
    public /*no synchronized here!*/ void stop ()
    	throws Exception
    {
    	CountDownLatch aSync    = null;
    	LoggerContext  aContext = null;
    	
    	synchronized(this)
    	{
    		if (m_aRunSync == null)
    			return;
    		
    		aSync           = m_aRunSync;
            m_aRunSync      = null;
            
            aContext        = m_aContext;
            m_aContext      = null;
            
            m_aConfigurator = null;
    	}
    	
    	aContext.stop     ();
    	aSync   .countDown();
    }

    //-------------------------------------------------------------------------
    public /*no synchronized here!*/ void join ()
    	throws Exception
    {
    	CountDownLatch aSync  = null;
    	synchronized(this)
    	{
    		if (m_aRunSync == null)
    			return;

    		aSync = m_aRunSync;
    	}

    	aSync.await();
    }

    //-------------------------------------------------------------------------
    private String m_sInterface = null;

    //-------------------------------------------------------------------------
    private int m_nPort = 0;

    //-------------------------------------------------------------------------
    private CountDownLatch m_aRunSync = null;

    //-------------------------------------------------------------------------
    private LoggerContext m_aContext = null;

    //-------------------------------------------------------------------------
    private JoranConfigurator m_aConfigurator = null;
}
