/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.office.tools.logging;

import org.apache.commons.lang3.Validate;
import org.apache.commons.logging.Log;

/**
 * Helper class to output messages and exceptions with the correct
 * log-level.
 *
 * @author Carsten Driesner
 *
 */
public class LogWithLevel {

    /**
     * Logs a message with an optional Throwable using the provided
     * log level.
     *
     * @param log the log object to be used to log the provided message and throwable.
     *        Must not be null.
     * @param logLevel the log-level to be used.
     * @param message the message to be used. Must not be null.
     * @param t An optional Throwable object. Can be null.
     */
    public static void log(final Log log, final ELogLevel logLevel, final String message, final Throwable t) {
        Validate.notNull(log);
        Validate.notNull(message);

        switch (logLevel) {
            case E_INFO:
                if (null == t) {
                    log.info(message);
                } else {
                    log.info(message, t);
                }
            break;

            case E_DEBUG:
                if (null == t) {
                    log.debug(message);
                } else {
                    log.debug(message, t);
                }
            break;

            case E_TRACE:
                if (null == t) {
                    log.trace(message);
                } else {
                    log.trace(message, t);
                }
            break;

            case E_WARNING:
                if (null == t) {
                    log.warn(message);
                } else {
                    log.warn(message, t);
                }
            break;

            case E_ERROR:
                if (null == t) {
                    log.error(message);
                } else {
                    log.error(message, t);
                }
            break;

            default:
                log.error("LOG error: log method called with unknown log level - check implementation!");
            break;
        }
    }
}
