/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.office.tools.directory;

import com.openexchange.office.tools.rt.EncodeUtility;


public class DocResourceID {

    private final String docResourceId;

    /**
     * Initializes a new {@link DocResourceID}.
     * @param id
     */
    private DocResourceID(final String id) {
        this.docResourceId = id;
    }

    /**
     * Creates a string representation of a DocResourceID.
     * @return a sting which represents this DocResourceID instance
     */
    @Override
    public String toString() {
        return this.docResourceId;
    }

    @Override
    public boolean equals(final Object other) {
        if (other == null) return false;
        if (other == this) return true;
        if (!(other instanceof DocResourceID)) return false;

        DocResourceID otherDocResourceID = (DocResourceID)other;
        return (otherDocResourceID.docResourceId.equals(docResourceId));
    }

    @Override
    public int hashCode() {
        return (null != docResourceId) ? docResourceId.hashCode() : 0;
    }

    /**
     * Creates a DocResourceID which consists of two values:
     *  - context id, resource as provided by real-time via GroupDispatcher getID().getResource()
     *
     * @param contextID the context id where the document exists
     * @param resourceId the resource id provided by real-time
     * @return a DocResourceID instance which is associated with the document
     *  described by the three arguments.
     */
    public static DocResourceID createDocResourceID(final String contextID, final String resourceId) {
        return new DocResourceID(contextID + "@" + resourceId);
    }

    public static DocResourceID createDocResourceAndEncodeResPart(final String contextID, final String resourceId) {
        return new DocResourceID(contextID + "@" + EncodeUtility.encodeResourcePart(resourceId));
    }

    public static DocResourceID createDocResourceID(final String docResourceID) {
        return new DocResourceID(docResourceID);
    }
}
