/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.tools.database;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.Enumeration;
import org.apache.commons.io.IOUtils;
import com.openexchange.office.tools.annotation.NonNull;
import liquibase.resource.ResourceAccessor;

/**
 * {@link DatabaseResourceAccessor}
 *
 * @author <a href="mailto:kai.ahrens@open-xchange.com">Kai Ahrens</a>
 * @since v7.10.1
 */
public class DatabaseResourceAccessor implements ResourceAccessor {

    /**
     * Initializes a new {@link DatabaseResourceAccessor}.
     * <b>UNUSED</b>
     */
    @SuppressWarnings("unused")
    private DatabaseResourceAccessor() {
        // Unused
    }

    /**
     * Initializes a new {@link DatabaseResourceAccessor}.
     * @param resourceName
     */
    public DatabaseResourceAccessor(@NonNull final String resourceName) {
        this.resourceName = resourceName;
    }

    /**
     * @return The name of the resource.
     */
    public String getResourceName() {
        return this.resourceName;
    }

    /**
     * @return
     */
    public ClassLoader getClassLoader() {
        final ClassLoader loader = toClassLoader();

        return (null != loader) ? loader : DatabaseResourceAccessor.class.getClassLoader();
    }

    /*
     * (non-Javadoc)
     *
     * @see liquibase.resource.ResourceAccessor#getResourceAsStream(java.lang.String)
     */
    @Override
    public InputStream getResourceAsStream(String file) throws IOException {
        ClassLoader loader = getClassLoader();

        final URL url = (null != loader) ? loader.getResource(file) : null;

        if (null != url) {
            final URLConnection con = url.openConnection();

            if (null != con) {
                con.connect();

                try (final InputStream resourceInputStm = con.getInputStream()) {
                    if (null != resourceInputStm) {
                        return new ByteArrayInputStream(IOUtils.toByteArray(resourceInputStm));
                    }
                }
            }
        }

        return null;
    }

    /*
     * (non-Javadoc)
     *
     * @see liquibase.resource.ResourceAccessor#getResources(java.lang.String)
     */
    @Override
    public Enumeration<URL> getResources(String packageName) throws IOException {
        return Collections.emptyEnumeration();
    }

    /*
     * (non-Javadoc)
     *
     * @see liquibase.resource.ResourceAccessor#toClassLoader()
     */
    @Override
    public ClassLoader toClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    // - Members ---------------------------------------------------------------

    private String resourceName;
}
