/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.office.tools.common.csv;

import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.List;

public class CSVEntryParser
{

    public static List<String> getCSVContentFromLine(
        String input,
        String[] seps)
            throws Exception
    {
        List<Object> toParse = new ArrayList<Object>();
        toParse.add(input);

        parseQuote(toParse, "\"");
        parseQuote(toParse, "'");
        for (String sep : seps)
        {
            parseSplit(toParse, sep);
        }

        List<String> res = new ArrayList<String>();
        for (Object o : toParse)
        {
            if (o instanceof SoftReference)
            {
                res.add(((SoftReference<?>) o).get().toString());
            }
            else
            {
                res.add((String) o);
            }
        }

        return res;
    }

    private static void parseSplit(
        List<Object> toParse,
        String split)
    {
        List<Object> tmpList = new ArrayList<Object>();

        for (int i = 0; i < toParse.size(); i++)
        {
            Object o = toParse.get(i);
            if (o instanceof SoftReference)
            {
                tmpList.add(o);
            }
            else
            {
                String[] splited = ((String) o).split(split);
                for (String s : splited)
                {
                    tmpList.add(s);
                }

            }
        }

        toParse.clear();
        toParse.addAll(tmpList);
    }

    private static void parseQuote(
        List<Object> toParse,
        String quote)
            throws Exception
    {
        List<Object> tmpList = new ArrayList<Object>();

        for (int i = 0; i < toParse.size(); i++)
        {
            Object o = toParse.get(i);
            if (o instanceof SoftReference)
            {
                tmpList.add(o);
            }
            else
            {
                String s = (String) o;
                int start = s.indexOf(quote);
                if (start >= 0)
                {
                    int end = s.indexOf(quote, start + 1);
                    if (end >= 0)
                    {
                        String before = s.substring(0, start);
                        String content = s.substring(start + 1, end);
                        String after = s.substring(end + 1);

                        if (before.length() > 0)
                        {
                            tmpList.add(before);
                        }
                        tmpList.add(new SoftReference<String>(content));

                        if (after.length() > 0)
                        {
                            toParse.add(i + 1, after);
                        }
                    }
                    else
                    {
                        throw new Exception("no end quote found (" + quote + ") in String: " + s);
                    }
                }
                else
                {
                    tmpList.add(o);
                }
            }
        }
        toParse.clear();
        toParse.addAll(tmpList);

    }

}
