/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.rt2.rest.osgi;

import java.util.List;

import com.openexchange.ajax.customizer.file.AdditionalFileField;
import com.openexchange.office.rt2.proxy.RT2DocProxyRegistry;
import com.openexchange.office.rt2.rest.RT2RESTActionFactory;
import com.openexchange.office.rt2.rest.json.fields.ResourceIDField;
import com.openexchange.office.session.SessionService;
import com.openexchange.office.tools.logging.v2.ELogLevel;
import com.openexchange.office.tools.logging.v2.impl.Logger;
import com.openexchange.office.tools.logging.v2.impl.Slf4JLogger;
import com.openexchange.office.tools.osgi.ActivatorBase;

public class RT2RESTActivator extends ActivatorBase {

	//-------------------------------------------------------------------------
	private static final String AJAX_MODULE_ID = "rt2";

	//-------------------------------------------------------------------------
    private static final String BUNDLE_ID = "com.openexchange.office.rt2.rest.osgi";

    //-------------------------------------------------------------------------
    private static final Logger LOG = Slf4JLogger.create(RT2RESTActivator.class);

	//-------------------------------------------------------------------------
    private RT2RESTActionFactory m_aAJAXModule = null;

    //-------------------------------------------------------------------------
	public RT2RESTActivator() throws Exception {
		super(BUNDLE_ID);
	}

    //-------------------------------------------------------------------------
	@Override
	protected void listMandatoryServiceImports(List<Class<?>> lServices) throws Exception {
		lServices.add (RT2DocProxyRegistry.class);
		lServices.add (SessionService.class);
	}

    //-------------------------------------------------------------------------
	@Override
	protected void listOptionalServiceImports(List<Class<?>> lServices) throws Exception {
		// no optional services are required
	}

    //-------------------------------------------------------------------------
	@Override
	protected void activate() throws Exception {
		LOG.forLevel(ELogLevel.E_INFO).withMessage(BUNDLE_ID + " started").log();

        m_aAJAXModule = new RT2RESTActionFactory();
        registerAJAXModule(m_aAJAXModule, AJAX_MODULE_ID, true);

        /*
         * register an additional file field providing the realtime resource identifier
         */
        registerService(AdditionalFileField.class, new ResourceIDField());
	}

    //-------------------------------------------------------------------------
	@Override
	protected void deactivate() throws Exception {
		LOG.forLevel(ELogLevel.E_INFO).withMessage(BUNDLE_ID + " stopped").log();
	}

}
