package com.openexchange.office.rt2.protocol.value;

import org.apache.commons.lang3.StringUtils;

public class RT2CliendUidType extends RT2ValueType<String> {

    public RT2CliendUidType() {
        super("");
    }

    public RT2CliendUidType(String type) {
        super(type);
    }

    public static boolean isNotEmptyAndEqual(final RT2CliendUidType r1, final RT2CliendUidType r2) {
    	if ((r1 != null) && (r2 != null) && StringUtils.isNotEmpty(r1.getValue()) && StringUtils.isNotEmpty(r2.getValue())) {
			return (r1.getValue()).equals(r2.getValue());
		}

		return false;
	}

    public static boolean isEmpty(final RT2CliendUidType r1) {
    	return ((r1 == null) || (r1.getValue().isEmpty()));
    }

    public static boolean isNotEmpty(final RT2CliendUidType r1) {
    	return !isEmpty(r1);
    }
}
