package com.openexchange.office.rt2.protocol.internal;

import org.apache.commons.lang3.StringUtils;

public enum Cause {

    SESSION_INVALID,
    GARBAGE_COLLECTING;

    //-------------------------------------------------------------------------
    public static String toString (final Cause cause)
    {
        if (cause == Cause.SESSION_INVALID)
            return SESSION_INVALID.toString();

        if (cause == Cause.GARBAGE_COLLECTING)
            return GARBAGE_COLLECTING.toString();

        throw new UnsupportedOperationException ("Unknown '"+cause+"' detected.");
    }

    //-------------------------------------------------------------------------
    public static Cause fromString (final String cause)
    {
        if (StringUtils.equalsIgnoreCase(cause, SESSION_INVALID.toString()))
            return Cause.SESSION_INVALID;

        if (StringUtils.equalsIgnoreCase(cause, GARBAGE_COLLECTING.toString()))
            return Cause.GARBAGE_COLLECTING;

        throw new UnsupportedOperationException ("Unknown '"+cause+"' detected.");
    }
}
