package com.openexchange.office.rt2.protocol;

import javax.jms.JMSException;
import javax.jms.Message;

import com.openexchange.office.rt2.protocol.RT2GoogleProtocol.BroadcastMessage;

public class GpbMessageJmsPostProcessor implements RT2MessagePostProcessor {

    public static final String HEADER_MSG_TYPE  = RT2Protocol.HEADER_PREFIX_INTERNAL + ".type";
    

    private final BroadcastMessage broadcastMsg;

    public GpbMessageJmsPostProcessor() {
        this.broadcastMsg = null;
    }    
    
    public GpbMessageJmsPostProcessor(BroadcastMessage broadcastMsg) {
        this.broadcastMsg = broadcastMsg;
    }

    @Override
    public Message postProcessMessage(Message msg) throws JMSException {
    	msg.setBooleanProperty(HEADER_VERSION_MSG_RCV, false);
    	msg.setBooleanProperty(HEADER_VERSION_MSG_SND, false);
    	if (broadcastMsg != null) {
    		msg.setStringProperty(HEADER_MSG_TYPE, broadcastMsg.getMsgType().name());
    	}
        msg.setBooleanProperty( HEADER_GPB_MSG, true);
        return msg;
    }
}
