package com.openexchange.office.rt2.jms;

import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import com.openexchange.office.rt2.core.RT2NodeInfoService;
import com.openexchange.office.tools.osgi.ServiceLookupRegistryService;

public class RT2DocProcessorJmsConsumerHolderImpl implements RT2DocProcessorJmsConsumerHolder {

    private static final Logger log = LoggerFactory.getLogger(RT2DocProcessorJmsConsumerHolder.class);
    private AtomicReference<RT2DocProcessorJmsConsumer> docProcessorJmsConsumerInstance = new AtomicReference<>(null);

    public RT2DocProcessorJmsConsumerHolderImpl(RT2DocProcessorJmsConsumer docProcessorJmsConsumer) {
        docProcessorJmsConsumerInstance.set(docProcessorJmsConsumer);
    }

    @Override
    public synchronized void reset() {
        RT2DocProcessorJmsConsumer oldDocProcessorJmsConsumer = docProcessorJmsConsumerInstance.get();
        if (oldDocProcessorJmsConsumer != null) {
            oldDocProcessorJmsConsumer.destroy();
        }

        final RT2NodeInfoService nodeInfoService = ServiceLookupRegistryService.getInstance().getService(RT2NodeInfoService.class);
        final String nodeUUID = nodeInfoService.getNodeUUID();
        RT2DocProcessorJmsConsumer newDocProcessorJmsConsumer = new RT2DocProcessorJmsConsumer();
        newDocProcessorJmsConsumer.startReceiveMessages();
        docProcessorJmsConsumerInstance.set(newDocProcessorJmsConsumer);
        log.info("RT2DocProcessorJmsConsumerHolderImpl reset RT2DocProcessorJmsConsumer instance to latest node-uuid {}", nodeUUID);
    }

    @Override
    public synchronized void destroy() {
        RT2DocProcessorJmsConsumer docProcessorJmsConsumer = docProcessorJmsConsumerInstance.get();
        if (docProcessorJmsConsumer != null) {
            docProcessorJmsConsumer.destroy();
            docProcessorJmsConsumerInstance.set(null);
        }
    }

}
