package com.openexchange.office.rt2.core.management;

import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.jms.JMSException;

public interface RT2BackendMBean {
	String getHazelcastUid();
    Map<String, String> getRT2DocProxies();
    List<String> getRT2DocProxyIds();
    int getCountRT2DocProxies();
    Map<String, String> getDocProcessors();
    List<String> getDocProcessorIds();
    int getCountRT2DocProcessors();
    void clearAll();
    long getGCTimeout();
    long getGCFrequency();
    void setGCTiming(Long timeout, Long frequency);
    String getDcsConnectionUrl() throws JMSException;
    
    void triggerRT2GC();
    
    Map<String, Integer> getMessageCountWaitingForAckOfDoc();
    int getCountQueuedMessagesOfProcessor();
    int getCountCurrentUsedProcessors();

    Set<String> getDocProxyMarkedForRemove();
    
    Set<String> getCurrentJmsConnections() throws Exception;
    
    List<String> getMsgsOfDocProxy(String clientUid, String docUid);
    List<String> getMsgsOfDocProxy(String proxyId);
    List<String> getMsgsOfDocProcessor(String docUid);
    List<String> getMsgsOfDocProcessor(String clientUid, String docUid);

    void setQueueSizeForMsgsOfDocProcessor(String docUid, int count);
    
    Map<String, String> getMessageProcessorRunningThreadTime();
    boolean terminateMessageProcessorThread(String docUid);
    List<String> getStackTraceOfMessageProcessorThread(String docUid);
    
    boolean removeDocProxy(String docProxyId);
    boolean removeDocProxy(String clientUid, String docUid);
    boolean removeDocProcessor(String docUid);
    
//    List<String> getAllHazelcastRT2LockObjects();
    List<String> getRegisteredRT2LockObjects();
    
    void unlockRT2LockObject(String docUid);
    void destroyRT2LockObject(String docUid);
    void runClusterLockUnlockThread();
    void runDocLockRemoveThread();
    
    public Map<String, Integer> getNotAckedMessageCount(String docUid);
    
    Integer getNackFrequenceOfServer();
    void updateNackFrequenceOfServer(Integer value);
    
    List<String> getAtomicLongsToGc();
	List<String> getAtomicLongsToBeVerified();
}
