/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.rt2.core.doc;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import com.openexchange.office.rt2.protocol.RT2Message;
import com.openexchange.office.tools.doc.SyncInfo;
import com.openexchange.office.tools.error.ErrorCode;

public class MessageHelper
{
    //-------------------------------------------------------------------------
	private MessageHelper() {}

    //-------------------------------------------------------------------------
	public static void setDocumentStatus(final RT2Message aMsg, final DocumentStatus aDocStatus) throws JSONException
	{
		final JSONObject aBody = aMsg.getBody();
		aBody.put(MessageProperties.PROP_DOCSTATUS, aDocStatus.toJSON());
		aMsg.setBody(aBody);
	}

    //-------------------------------------------------------------------------
	public static void setDocumentStatus(final RT2Message aMsg, final JSONObject aDocStatus)
		throws Exception
	{
		final JSONObject aBody = aMsg.getBody();
		aBody.put(MessageProperties.PROP_DOCSTATUS, aDocStatus);
		aMsg.setBody(aBody);
	}

    //-------------------------------------------------------------------------
	public static void setClientsStatus(final RT2Message aMsg, final ClientsStatus aClientsStatus, boolean bComplete)
		throws Exception
	{
		final JSONObject aBody = aMsg.getBody();
		if (bComplete)
			aBody.put(MessageProperties.PROP_CLIENTS, aClientsStatus.toFullJSON());
		else
			aBody.put(MessageProperties.PROP_CLIENTS, aClientsStatus.toJSON());
		aMsg.setBody(aBody);
	}

    //-------------------------------------------------------------------------
	public static void setClientsStatus(final RT2Message aMsg, final JSONObject aClientsStatus)
		throws Exception
	{
		final JSONObject aBody = aMsg.getBody();
		aBody.put(MessageProperties.PROP_CLIENTS, aClientsStatus);
		aMsg.setBody(aBody);
	}

    //-------------------------------------------------------------------------
	public static JSONObject getError(final RT2Message aMsg)
		throws Exception
	{
		return aMsg.getBody().getJSONObject(MessageProperties.PROP_ERROR);
	}

    //-------------------------------------------------------------------------
	public static void setError(final RT2Message aMsg, final ErrorCode aErrorCode)
		throws Exception
	{
		aMsg.getBody().put(MessageProperties.PROP_ERROR, aErrorCode.getAsJSON());
	}

    //-------------------------------------------------------------------------
	public static JSONArray getOperations (final RT2Message aMsg)
		throws Exception
	{
		return aMsg.getBody().getJSONArray(MessageProperties.PROP_OPERATIONS);
	}

    //-------------------------------------------------------------------------
	public static void setOperations (final RT2Message aMsg, final JSONArray lOps)
		throws Exception
	{
		aMsg.getBody().put(MessageProperties.PROP_OPERATIONS, lOps);
	}

    //-------------------------------------------------------------------------
	public static void setHtmlDoc (final RT2Message aMsg, final String htmlDoc)
		throws Exception
	{
		aMsg.getBody().put(MessageProperties.PROP_HTMLDOC, htmlDoc);
	}

    //-------------------------------------------------------------------------
	public static String getHtmlDoc (final RT2Message aMsg)
		throws Exception
	{
		return aMsg.getBody().getString(MessageProperties.PROP_HTMLDOC);
	}

    //-------------------------------------------------------------------------
	public static void setSyncInfo (final RT2Message aMsg, final SyncInfo syncInfo)
		throws Exception
	{
		aMsg.getBody().put(MessageProperties.PROP_SYNCINFO, syncInfo.toJSON());
	}

    //-------------------------------------------------------------------------
	public static SyncInfo getSyncInfo (final RT2Message aMsg)
		throws Exception
	{
		final JSONObject aJSONSyncInfo = aMsg.getBody().getJSONObject(MessageProperties.PROP_SYNCINFO);
		return new SyncInfo(aJSONSyncInfo);
	}

	//-------------------------------------------------------------------------
	public static int getCurrentSlide (final RT2Message aMsg)
		throws Exception
	{
		final JSONObject aSlideInfo = aMsg.getBody().getJSONObject(MessageProperties.PROP_SLIDEINFO);
		return aSlideInfo.getInt(MessageProperties.PROP_ACTIVESLIDE);
	}

    //-------------------------------------------------------------------------
	public static void setCurrentSlide (final RT2Message aMsg, int nActiveSlide)
		throws Exception
	{
		final JSONObject aSlideInfo = aMsg.getBody().getJSONObject(MessageProperties.PROP_SLIDEINFO);
		aSlideInfo.put(MessageProperties.PROP_ACTIVESLIDE, nActiveSlide);
	}

    //-------------------------------------------------------------------------
	public static void setActiveSheet (final RT2Message aMsg, int nActiveSheet)
		throws Exception
	{
		aMsg.getBody().put(MessageProperties.PROP_ACTIVESHEET, nActiveSheet);
	}

	//-------------------------------------------------------------------------
	public static JSONObject getResult (final RT2Message aMsg)
		throws Exception
	{
		return aMsg.getBody().optJSONObject(MessageProperties.PROP_RESULT);
	}

    //-------------------------------------------------------------------------
	public static void setResult (final RT2Message aMsg, final JSONObject aResult)
		throws Exception
	{
		JSONObject aBody = aMsg.getBody();
		if (null == aBody)
			aBody = new JSONObject();

		aBody.put(MessageProperties.PROP_RESULT, aResult);
	}

    //-------------------------------------------------------------------------
	public static void setForceEditResult (final RT2Message aMsg, final boolean bForceEditApproved)
		throws Exception
	{
		JSONObject aBody = aMsg.getBody();
		if (null == aBody)
			aBody = new JSONObject();

		aBody.put(MessageProperties.PROP_FORCEEDITRESULT, bForceEditApproved);
	}

}
