package com.openexchange.office.rt2.core.control;

public abstract class DelayedTask extends Task
{
    //-------------------------------------------------------------------------
	private final long m_nCreatedInMS;

    //-------------------------------------------------------------------------
	private final long m_nDelayInMS;

    //-------------------------------------------------------------------------
	public DelayedTask(String sTaskID, long nDelayInMS)
	{
		super(sTaskID);

		m_nCreatedInMS = System.currentTimeMillis();
		m_nDelayInMS   = nDelayInMS;
	}

    //-------------------------------------------------------------------------
	public long getCreatedTime()
	{
		return m_nCreatedInMS;
	}

    //-------------------------------------------------------------------------
	public long getDelay()
	{
		return m_nDelayInMS;
	}

    //-------------------------------------------------------------------------
	@Override
	public String toString()
	{
		final StringBuilder aTmp = new StringBuilder(super.toString());
		aTmp.append(", created: ");
		aTmp.append(m_nCreatedInMS);
		aTmp.append(", delay: ");
		aTmp.append(m_nDelayInMS);
		return aTmp.toString();
	}
}
