package com.openexchange.office.rt2.core;

import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.openexchange.office.rt2.jms.JmsMessageSender;
import com.openexchange.office.rt2.protocol.RT2GoogleProtocol.AdminMessage;
import com.openexchange.office.rt2.protocol.RT2GoogleProtocol.AdminMessageType;
import com.openexchange.office.rt2.protocol.RT2GoogleProtocol.MessageTimeType;
import com.openexchange.office.rt2.protocol.RT2GoogleProtocol.ServerIdType;
import com.openexchange.office.rt2.protocol.RT2GoogleProtocol.SessionIdType;
import com.openexchange.session.Session;
import com.openexchange.sessiond.SessiondEventConstants;

public class RemoveSessionListenerService implements EventHandler {

	private static final Logger log = LoggerFactory.getLogger(RemoveSessionListenerService.class);
	
	private final JmsMessageSender jmsMessageSender;
	
	private final RT2NodeInfoService nodeInfoService;
	
	public RemoveSessionListenerService(JmsMessageSender jmsMessageSender, RT2NodeInfoService nodeInfoService) {
		this.jmsMessageSender = jmsMessageSender;
		this.nodeInfoService = nodeInfoService;
	}

	@Override
	public void handleEvent(Event event) {
		Session session = (Session) event.getProperty(SessiondEventConstants.PROP_SESSION);
		log.info("Received session removed event for session id {}", session.getSessionID());
		AdminMessage adminRequest = AdminMessage.newBuilder()
				.setMsgType(AdminMessageType.ADMIN_TASK_SESSION_REMOVED)
				.setMessageTime(MessageTimeType.newBuilder().setValue(System.currentTimeMillis()))
				.setServerId(ServerIdType.newBuilder().setValue(nodeInfoService.getNodeUUID()))
				.setOriginator(ServerIdType.newBuilder().setValue(nodeInfoService.getNodeUUID()))
				.setSessionId(SessionIdType.newBuilder().setValue(session.getSessionID()).build())
				.build();
		jmsMessageSender.sendAdminMessage(adminRequest);		
	}
}
